<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
use App\Tag;

Route::pattern('id', '[0-9]+');
Route::pattern('userid', '[0-9]+');
Route::pattern('slug', '[A-Za-z0-9-]+');
Route::pattern('slug1', '[A-Za-z0-9-]+');
Route::pattern('token', '[A-Za-z0-9]+');
Route::pattern('viewonly','[A-Za-z]+');
Route::pattern('file','[A-Za-z0-9\.\-\_]+');
Route::pattern('status','[A-Za-z]+');
Route::pattern('type','[A-Za-z]+');
Route::pattern('countryCode','[A-Za-z]+');



Route::domain(config('app.marketing_domain'))->middleware(['checkStatus'])->group(function () {



    Route::get('/', 'Marketing\HomeController@index')->name('home.marketing');

    Route::get('login', 'Marketing\LoginController@loginForm')->name('marketing.login');

    Route::get('download/{file}', function ($file) {
        $file_extension = strtolower(substr(strrchr($file,"."),1));
        switch( $file_extension ) {
            case "png": $ctype="image/png"; break;
            case "jpeg":
            case "jpg": $ctype="image/jpeg"; break;
            default:
        }
        return response()->download('uploads/images/'.$file, 'presentation.jpg', ['Content-type'=>$ctype]);
    })->name('download');


    Route::middleware(['ajax'])->group(function () {
        Route::post('login', 'Marketing\LoginController@postLogin')->name('marketing.ajLogin');

    });
    Route::middleware(['ajax','auth'])->group(function () {
      /*  Route::post('/payout/action', 'Marketing\AjaxController@payout')->name('ajax.payout');*/
        Route::post('/ajax_upload/action','Marketing\AjaxController@upload')->name('ajaxupload.action');
        Route::post('/picture/upload','Marketing\AjaxController@uploadD')->name('photo.upload');
    });


    Route::post('login/submit', 'Marketing\LoginController@login')->name('marketing.loginact');
    Route::any('/payout/success', 'Marketing\PayoutController@success')->name('payout.success');
    Route::any('/payout/fail', 'Marketing\PayoutController@fail')->name('payout.fail');
    Route::any('/payout/info', 'Marketing\PayoutController@info')->name('payout.info');


    Route::middleware(['auth'])->group(function () {
        Route::get('/dashboard', 'Marketing\HomeController@dashboard')->name('marketing.dashboard');
        Route::post('logout', 'Marketing\LoginController@logout')->name('marketing.logout');
        Route::get('tools', 'Marketing\BusinessCardController@index')->name('marketing.tools');

    });

    Route::get('{slug?}', 'Marketing\HomeController@page')->name('mkt.page');

});
Route::get('/', 'HomeController@index')->name('home.front');
Route::get('/wiiviggo', 'Common\WiiController@index')->name('wii.index');
Route::get('/companypres', 'Common\WiiController@company')->name('wii.company');
Route::domain(config('app.app_domain'))->group(function () {



    Auth::routes();


    Route::get('/contact_us','HomeController@contact')->name('contact-us');
    Route::get('/languageDemo', 'HomeController@languageDemo');
    Route::post('/contact_us_submit','HomeController@contactSubmit')->name('contact-submit');


    Route::middleware(['isAm','checkSubscription'])->group(function () {

        Route::middleware(['ajax'])->group(function () {
            Route::post('/videos/action', 'Common\VideosController@video')->name('video.action');
        });

        Route::get('/bo/videos', 'Common\VideosController@index')->name('bo.videos');
        Route::post('/bo/videos', 'Common\VideosController@index')->name('bo.videos.filter');
        Route::get('/bo/coaches', 'Bo\DashboardController@index')->name('bo.coaches');
        Route::get('/bo/intros', 'Bo\VideoController@intros')->name('bo.intros');
        Route::post('/bo/intros', 'Bo\VideoController@intros')->name('bo.intros.filter');
        Route::post('/bo/intros/action', 'Bo\AjaxController@intros')->name('bo.intros.action');
        Route::post('/bo/coaches/account', 'Bo\AjaxController@coaches')->name('bo.coaches.account');

    });


    Route::get('/join/coachurl/{coachurl?}', 'UserSignupController@join')->name('join');
    Route::get('/signup/{id?}/coachurl/{coachurl?}', 'UserSignupController@create')->name('users.create');

    Route::post('/signup/submit', 'UserSignupController@submit')->name('users.submit');
    Route::get('/verify/{email}/{secret}', 'Auth\VerificationController@verifyEmail')->name('verify.email');
    Route::get('validation/checkusername', 'ValidationController@checkemail')->name('validation.email');


    Route::middleware(['checkSubscription'])->group(function () {
        Route::get('/', 'HomeController@index')->name('home');
        Route::get('/tagssuggest', function () {
            return response()->json(Tag::pluck('title'), 200);
        });
        Route::get('/password/create/{token}', 'Auth\CreatePasswordController@index')->name('password.create');

        Route::get('/coach', 'HomeController@coach')->name('coach');

    // Payment / Packages



        Route::get('/coaches', 'Common\CoachesController@index')->name('coaches');
        Route::get('/coach/{id}', 'Common\CoachesController@profile')->name('coach.profile');
        Route::post('/coaches', 'Common\CoachesController@index')->name('coaches.filter');

        Route::get('/videos', 'Common\VideosController@library')->name('videos');
        Route::post('/videos/', 'Common\VideosController@library')->name('videos.filter');

        Route::get('/video/play/{id}', 'Common\VideosController@play')->name('video.play');


        Route::get('/payment/success', 'PaymentController@success')->name('payment.success');
        Route::get('/payment/giftsuccess', 'PaymentController@giftsuccess')->name('payment.gift.success');

        Route::get('/user/signupreceiver', 'UserSignupController@receiver')->name('gift.user.create');

        Route::get('/payment/companysuccess', 'PaymentController@companysuccess')->name('payment.company.success');
        Route::get('/payment/signedup', 'PaymentController@trialsuccess')->name('payment.trial_success');
        Route::get('/payment/fail', 'PaymentController@fail')->name('payment.fail');


        Route::get('/vimeo', 'HomeController@vimeo', 'vimeo');




    });

    Route::any('/payment/info', 'PaymentController@info')->name('payment.info');
    Route::any('/payment/callback', 'PaymentController@callback')->name('payment.callback');


    // Coach Pages Route

    Route::get('/coach/signup', 'SignupController@create')->name('coach.users.create');
    Route::post('/coach/submit', 'SignupController@submit')->name('coach.users.submit');
    Route::get('/thanks/{id?}', 'Common\ThanksController@signup')->name('signup.thanks');


    // Company Pages Routes

    Route::get('/coach/createcompany', 'CreatecompanyController@create')->name('company.create');
    Route::post('/company/submit', 'CreatecompanyController@submit')->name('company.submit');
    Route::get('/coach/retreiveCompanies', 'RetrievecompaniesController@index')->name('company.get');
    Route::get('/company/edit/{company_id}/{updateFormData}', 'CreatecompanyController@edit')->name('company.edit');
    Route::get('/company/delete/{company_id}', 'CreatecompanyController@delete')->name('company.delete');

    Route::get('/company/test', 'PaymentController@checkCompanyPayments')->name('company.check');

    Route::get('/employee/delete/{employee_id}', 'RetrievecompaniesController@delete')->name('company.employee.delete');
    Route::get('/company/updatetrans/{trans_id}', 'CreatecompanyController@updatetrans')->name('company.updatetrans');
    Route::get('/company/viewpaymenthistory/{company_id}', 'RetrievecompaniesController@viewpaymenthistory')->name('company.viewpaymenthistory');
    Route::get('/company/viewcompanyemployees/{company_id}', 'RetrievecompaniesController@viewcompanyemployees')->name('company.viewcompanyemployees');
    Route::get('/companyinvoice/downloadpdf', 'DownloadPdfController@generatePDF')->name('company.downloadpdf');


    // Company Employees Signup Routes

    Route::get('/company/signupemployee', 'Company\SignupEmployeeController@create')->name('company.employee.create');
    Route::post('/companyemployee/submit', 'Company\SignupEmployeeController@submit')->name('company.employee.submit');
    Route::post('companyemployee/login', 'Company\LoginController@postLogin')->name('company.employee.login');

    //Common
    Route::get('/tags/get', 'Common\AjaxController@tags')->name('tags.get');
    Route::get('/vat/get/{countryCode}/{id}/{packageVal}', 'Common\AjaxController@vat')->name('vat.get');

    Route::middleware(['ajax'])->group(function () {

    Route::get('refreshcaptcha', 'Common\AjaxController@refreshCaptcha');
    });

    Route::middleware(['ajax','auth','CheckAccount'])->group(function () {

        Route::post('/subscription', 'Common\AjaxController@subscription')->name('subscription');
        Route::post('/favorite', 'Common\AjaxController@favorite')->name('favorite');
        Route::post('/payout', 'Common\AjaxController@payout')->name('ajax.payout');

    });

    Route::middleware(['auth','CheckAccount','isUser','checkSubscription'])->group(function () {
        Route::get('/questions', 'Common\QuestionsController@user')->name('questions');
        Route::post('/question/add', 'Common\QuestionsController@add')->name('question.add');

    });


    Route::middleware(['auth','CheckAccount'])->group(function () {
        Route::get('/subscribe', 'PaymentController@subscribe')->name('subscribe');
        Route::get('/profile/edit', 'Member\AccountController@edit')->name('users.edit');
        Route::get('/account/payments', 'Member\PaymentHistoryController@index')->name('user.payments');
        Route::get('user/gift', 'GiftController@index')->name('user.joingift');
        Route::get('/signup/{id?}/gift/1', 'GiftController@giftcreate')->name('users.gift.create');
        Route::get('/receiver/details/{rid?}/{uId?}', 'GiftController@receiverDetails')->name('users.gift.receiver');
        Route::post('/receiver/submitdetails', 'GiftController@submitgift')->name('users.gift.submit');
        Route::get('/payments/process/{id?}', 'PaymentController@upgrade')->name('user.renew_package');
        Route::post('/member/recurring', 'Member\AjaxController@recurring')->name('user.recurring_ajax');
        Route::post('/member/profile/update', 'Member\AccountController@update')->name('user.profile.update');
    });
    Route::get('/giftuser/signup/{user_id}', 'GiftController@gusersignup')->where('user_id', '[0-9]+')->name('giftuser.signup.create');
    Route::post('/giftuser/submit', 'GiftController@submit')->name('giftuser.signup.submit');
    Route::get('/profile/employeeedit', 'Member\AccountController@employeerequest')->name('users.employee');
    Route::post('/member/profile/update', 'Member\AccountController@update')->name('user.profile.update');
    Route::get('/profile/edit', 'Member\AccountController@edit')->name('users.edit');

    Route::middleware(['auth','CheckAccount','ajax', 'isSuper'])->group(function () {

        Route::post('/bo/member/update','Bo\AjaxController@update')->name('bo.member.update');
        Route::post('/bo/member/status','Bo\AjaxController@status')->name('bo.member.status');

    });




    Route::middleware(['auth','CheckAccount', 'mixed'])->group(function () {
        Route::get('/bo/coach/profile/{id}', 'Bo\DashboardController@profile')->name('bo.coach.profile');
        Route::get('/bo/dashboard', 'Bo\DashboardController@index')->name('bo.dashboard');
        Route::get('/bo/sendmail', 'Bo\DashboardController@sendmail')->name('bo.sendmail');
        /*Route::get('/bo/coaches', 'Bo\DashboardController@index')->name('bo.coaches');*/

       /* Route::get('/bo/intros', 'Bo\VideoController@intros')->name('bo.intros');
        Route::post('/bo/intros', 'Bo\VideoController@intros')->name('bo.intros.filter');
        Route::post('/bo/intros/action', 'Bo\AjaxController@intros')->name('bo.intros.action');*/


        Route::post('/bo/dashboard', 'Bo\DashboardController@index')->name('bo.dashboard.filter');
        Route::get('/bo/questions', 'Bo\QuestionsController@index')->name('bo.questions');
        Route::get('/bo/question/delete/{id}', 'Bo\QuestionsController@delete')->name('bo.question.delete');
        Route::get('/bo/payouts', 'Bo\PayoutsController@index')->name('bo.payouts');
        Route::get('/company/payouts', 'Bo\CompanyPayoutsController@index')->name('company.payouts');
        Route::get('/bo/payouts/{month}/{year}', 'Bo\PayoutsController@export')->name('bo.export');
        Route::get('/company/payouts/{month}/{year}', 'Bo\CompanyPayoutsController@export')->name('bo.company.export');
        Route::get('/bo/staff/{id?}', 'Bo\StaffController@index')->name('bo.staff');
        Route::get('/bo/staff/delete/{id}', 'Bo\StaffController@delete')->name('bo.staff.delete');
        Route::post('/bo/staff/submit', 'Bo\StaffController@submit')->name('bo.staff.submit');

        /*Route::get('/bo/videos', 'Common\VideosController@index')->name('bo.videos');
        Route::post('/bo/videos', 'Common\VideosController@index')->name('bo.videos.filter');*/

        Route::get('/bo/categories', 'Bo\CategoriesController@index')->name('bo.categories');
        Route::post('/bo/categories/submit', 'Bo\CategoriesController@submit')->name('bo.categories.add');


        Route::get('/bo/pages', 'Bo\SitePagesController@index')->name('bo.pages');
        Route::get('/bo/page/{id}/{type?}', 'Bo\SitePagesController@edit')->name('bo.page.edit');
        Route::post('/bo/page/submit', 'Bo\SitePagesController@submit')->name('bo.page.submit');

        Route::get('/bo/packages', 'Bo\PackagesController@index')->name('bo.packages');
        Route::get('/bo/createpackage', 'Bo\PackagesController@create')->name('bo.package.create');
        Route::get('/bo/package/{id}', 'Bo\PackagesController@edit')->name('bo.package.edit');
        Route::get('/bo/delpackage/{id}', 'Bo\PackagesController@delete')->name('bo.package.delete');
        Route::post('/bo/package/submit', 'Bo\PackagesController@submit')->name('bo.package.submit');

        Route::get('/bo/members','Bo\MembersController@index')->name('manage.members');

    });

    Route::middleware('mixed')->group(function () {

        Route::get('/bo/coach/profile/{id}', 'Bo\DashboardController@profile')->name('bo.coach.profile');
    });


    Route::middleware(['ajax','mixed'])->group(function () {

        Route::post('/video/questions/update', 'Common\QuestionsController@update')->name('q.questions.update');

        Route::get('/intro/check', 'Common\AjaxController@introcheck')->name('intro.check');

    });

    Route::middleware(['auth','CheckAccount', 'mixed'])->group(function () {


        Route::get('/coach/profile', 'Coach\DashboardController@index')->name('coach.dashboard');
        Route::get('/coach/profile/edit', 'Coach\DashboardController@edit')->name('coach.profile.edit');
        Route::post('/coach/profile/update', 'Coach\DashboardController@update')->name('coach.profile.update');
        Route::post('/coach/intro/add','Coach\IntroController@submit')->name('coach.intro.add');

        Route::get('/coach/intro', 'Coach\IntroController@index')->name('coach.intro');
        Route::get('/coach/intro/edit/{id}', 'Coach\IntroController@edit')->name('coach.intro.edit');
        Route::get('/coach/intro/delete/{id}', 'Coach\IntroController@delete')->name('coach.intro.delete');
        Route::post('/coach/intro/update','Coach\IntroController@update')->name('coach.intro.update');


        Route::get('/coach/video/edit/{id}', 'Coach\VideoController@edit')->name('coach.video.edit');
        Route::post('/coach/video/update','Coach\VideoController@update')->name('coach.video.update');
        Route::get('/my/videos', 'Common\VideosController@index')->name('my.videos');

        Route::get('/video/upload/{id?}', 'Coach\VideoController@index')->name('video.upload');
        Route::post('/video/upload/submit', 'Coach\VideoController@submit')->name('video.upload.submit');

        Route::get('/video/questions', 'Common\QuestionsController@coach')->name('q.questions');
        Route::get('/speakers/pool', 'Bo\PayoutsController@pool')->name('coaches.pool');
        Route::get('account', 'Marketing\AccountController@index')->name('marketing.account');
    });

    Route::post('ckeditor/image_upload', 'CKEditorController@upload')->name('upload');
    Route::get('{slug?}', 'HomeController@page')->name('cms.page');
    Route::get('lang/{lang}', ['as' => 'lang.switch', 'uses' => 'ChangeLanguageController@switchLang']);

});
