@extends('layouts.app')
@section('content')

    <!-- projects area start -->
    <div id="UploadVideo" class="wrap-bg">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 mt-4">
                            @if (Auth::check())
                                @if($video->is_favorite==true)
                                <div class="expand_button"> <a href="#" class="btn e-button btn-sm  favorite favorited" data-id="{{$video->id}}" data-type="unfavorite"> <span class="e-button-text"><i class="fa fa-heart " style="padding-right:3px;"></i> Remove from Favorite</span> </a> </div>

                                @else
                                <div class="expand_button"> <a href="#" class="btn e-button btn-sm  favorite" data-id="{{$video->id}}" data-type="favorite"> <span class="e-button-text"><i class="fa fa-heart " style="padding-right:3px;"></i> Add to Favorite</span> </a> </div>

                                @endif
                            @endif
                        <div class="embed-responsive embed-responsive-16by9 z-depth-1-half">
                            <iframe class="embed-responsive-item" src="https://player.vimeo.com/video/{{$video->video_id}}"
                                width="640" height="360" frameborder="0" allow="autoplay; fullscreen"
                                allowfullscreen=""></iframe>

                        </div>
                    </div>
                </div>
                <div class="row">

                    <div class="col-md-12">
                        <div class="text-left video-player-coach ">
                            <div class="container">
                                <div class="row">
                                    <div class="col-lg-6 col-md-12 mt-3 p-0">
                                        <a href="{{route('coach.profile',['id'=>$video->user->id])}}"><h3 class="coach-title">{{ucwords($video->user->first_name.' '.$video->user->last_name)}}</h3></a>


                                    </div>
                                    <div class="col-lg-6 col-md-12 mt-3 p-0">
                                    @if(isset($subscription) && Auth::check())
                                        @if($subscription==1)
                                        <a class="color-two btn-custom subscribe submob ml-1 mr-1" href="#" data-id="{{$video->user->id}}"
                                            data-type="unsubscribe">Afmelde Coach</a>
                                            @else
                                        <a class="color-two btn-custom subscribe submob ml-1 mr-1" href="#" data-id="{{$video->user->id}}"
                                            data-type="subscribe">Følg Coach</a>
                                            @endif

                                    @endif
                                    @hasrole('user')
                                        <a data-toggle="modal" data-target="#modalaskQuestion" class="color-two btn-custom askQuestion submob" href="#">Skriv til panelet</a>
                                    @endhasrole
                                    </div>
                                    <div class="col-md-12 mt-3 p-0">
                                         <h4>{{$video->video_title}}</h4>
                                    </div>
                                     <div class="col-md-12 p-0">
                                        <p>{{$video->video_description}}</p>
                                    </div>

                                </div>

                                <div class="row">
                                    <div class="col-md-12 p-0">
                                        @if(count($video->categories)>0)
                                            @foreach($video->categories as $category)
                                            <a href="{{route('videos')}}?category={{$category->id}}" class="videoCategories">{{$category->title}}</a>
                                            @endforeach
                                        @endif
                                    </div>

                                </div>





                            </div>
                        </div>
                    </div>
                </div>
                <!-- .row -->
                @if(count($related) > 0)

                <div class="row related-videos mt-4">
                    <div class="col-md-12 mt-2">
                        <h4>Lignende Videoer</h4>

                    </div>

                    <div class="container">

                        <div class="row">
                        @foreach($related as $item)
                            @php
                                $fullName = $item->user->first_name.' '.$item->user->last_name;
                            @endphp
                            <div class="col-lg-3 col-md-4 col-sm-6 col-12">

                                    @if (Auth::check())
                                    @if($item->is_favorite==true)
                                <div class="expand_button"> <a href="#" class="btn e-button btn-sm  favorite favorited" data-id="{{$item->id}}" data-type="unfavorite"> <span class="e-button-text"><i class="fa fa-heart " style="padding-right:3px;"></i> Remove from Favorite</span> </a> </div>

                                @else
                                <div class="expand_button"> <a href="#" class="btn e-button btn-sm  favorite" data-id="{{$item->id}}" data-type="favorite"> <span class="e-button-text"><i class="fa fa-heart " style="padding-right:3px;"></i> Add to Favorite</span> </a> </div>

                                @endif
                                    @endif
                                    @if (Auth::check())
                                        <a id="videoPlayer" href="{{route('video.play',['id'=>$item->id])}}" class="color-gray-darker td-hover-none">
                                    @else
                                         <a data-id='login' href="#" class="color-gray-darker td-hover-none lg_in">
                                        @endif
                                    <div class="ba-0 ds-1 like-content">

                                        <div class="course-viewer">
                                            <ul>

                                                <li>
                                                    {{ gmdate("H:i:s", $item->video_duration) }}
                                                </li>
                                            </ul>
                                        </div>

                                        <div style="background-image: url({{ asset('uploads/images/'.$item->video_thumbnail) }});" class="card-img-top"></div>
                                        <div class="card-body">
                                            <span class="coach-name  " >{!! Str::limit($fullName, 50, ' ...') !!}
                                            </span>
                                            <h4 class="card-title color-gray-darker" >{!! Str::limit($item->video_title, 20, ' ...') !!}
                                            </h4>
                                            <p class="card-text color-gray-darker" >{!! Str::limit($item->video_description, 120, ' ...') !!}</p>
                                        </div>
                                    </div>
                                </a>

                            </div>
                        @endforeach
                        </div>




                    </div>




                </div>
                <!-- .row end -->

                @endif
                <!-- .row -->

                @if(count($more) > 0)

                <div class="row">
                    <div class="col-md-12 mt-4">
                        <h4>Mere fra {{ucwords($video->user->first_name.' '.$video->user->last_name)}}</h4>
                    </div>

                    <div class="container">

                        <div class="row">
                        @foreach($more as $item)
                            @php
                                $fullName = $item->user->first_name.' '.$item->user->last_name;
                            @endphp
                            <div class="col-lg-3 col-md-4 col-sm-6 col-12">

                                    @if (Auth::check())
                                    @if($item->is_favorite==true)
                                <div class="expand_button"> <a href="#" class="btn e-button btn-sm  favorite favorited" data-id="{{$item->id}}" data-type="unfavorite"> <span class="e-button-text"><i class="fa fa-heart " style="padding-right:3px;"></i> Remove from Favorite</span> </a> </div>

                                @else
                                <div class="expand_button"> <a href="#" class="btn e-button btn-sm  favorite" data-id="{{$item->id}}" data-type="favorite"> <span class="e-button-text"><i class="fa fa-heart " style="padding-right:3px;"></i> Add to Favorite</span> </a> </div>

                                @endif
                                    @endif
                                    @if (Auth::check())
                                        <a id="videoPlayer" href="{{route('video.play',['id'=>$item->id])}}" class="color-gray-darker td-hover-none">
                                    @else
                                         <a data-id='login' href="#" class="color-gray-darker td-hover-none lg_in">
                                        @endif
                                    <div class="ba-0 ds-1 like-content">

                                        <div class="course-viewer">
                                            <ul>

                                                <li>
                                                    {{ gmdate("H:i:s", $item->video_duration) }}
                                                </li>
                                            </ul>
                                        </div>

                                        <div style="background-image: url({{ asset('uploads/images/'.$item->video_thumbnail) }});" class="card-img-top"></div>
                                        <div class="card-body">
                                            <span class="coach-name  " >{!! Str::limit($fullName, 50, ' ...') !!}
                                            </span>
                                            <h4 class="card-title color-gray-darker" >{!! Str::limit($item->video_title, 20, ' ...') !!}
                                            </h4>
                                            <p class="card-text color-gray-darker">{!! Str::limit($item->video_description, 120, ' ...') !!}</p>
                                        </div>
                                    </div>
                                </a>

                            </div>
                        @endforeach
                        </div>




                    </div>




                </div>
                <!-- .row end -->

                @endif

            </div>
        </div>
        <!-- projects area end -->
        @hasrole('user')
            @include('partials.app.question',['refresh'=>'no'])
        @endhasrole
@endsection
@push('scripts')
<script>


    $(document).ready(function () {
        console.log( "ready!" );

    });

</script>
@endpush
