@extends('layouts.app')
@section('content')
    @php

        $collectionOfRoles = ['coach','superadmin','is_am'];
        $coachOnly = ['coach'];

    @endphp
    <div id="UploadVideo" class="wrap-bg">
<div class="container">
<h3>Godkend videoer</h3>
    <div class="library-filter mb20">
        <div class="container">
            <form action="{{route('bo.videos.filter')}}" id="filter_form">
                {{ csrf_field() }}
                <div class="row ">

                    <div class="col-lg-3 col-md-6 col-sm-6 mt-1 mb-1">
                        {{ Form::select('category', [null=>'Søg Efter kategori'] + $categories, isset($category) ? $category : null , ['class' => 'form-control filter ']) }}


                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 mt-1 mb-1">
                        {{ Form::select('language', [null=>'Alle'] + $languages, isset($language) ? $language : null , ['class' => 'form-control filter']) }}

                    </div>


                    <div class="col-lg-3 col-md-6 col-sm-6 mt-1 mb-1">
                        {{--{{ Form::select('state', $duration, isset($state) ? $state : null , ['class' => 'form-control filter']) }}--}}


                    </div>
                    @if (Auth::check())
                        @hasanyrole($collectionOfRoles)
                        @if(isset($statuses))
                            <div class="col-lg-3 col-md-6 col-sm-6 mt-1 mb-1">

                                {{ Form::select('status', $statuses, isset($status) ? $status : null , ['class' => 'form-control filter']) }}

                            </div>
                        @endif
                        @endhasanyrole
                    @else
<!--                        <div class="col-sm-3">


                        </div>-->
                    @endif
                </div>
            </form>
        </div>
    </div>



        <div class="container">
            <!-- .row -->
            <div class="row">

                <div class="container mt-2 p-0">
                    @include('common.flash_messages')
                    @if(count($videos)>0)
                        <div class="row">

                            @foreach($videos as $video)
                                <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                                    @if (Auth::check())


                                        <div class="iconsets">
                                            @if(Auth::user()->hasAnyRole($collectionOfRoles))
                                                <button data-toggle="tooltip" data-placement="right"
                                                        title="Godkend Video" class=" statusactive vd_act"
                                                        style="{{($video->status=='approved'? 'display:none': '')}}"
                                                        data-id="{{ $video->id }}" data-type="approved"><i
                                                        class="fa fa-check " aria-hidden="true"></i></button>
                                                <button data-toggle="tooltip" data-placement="right"
                                                        title="Afvis Video" class="vd_act statusdeactive"
                                                        style="{{($video->status=='pending') ? '': 'display:none'}}"
                                                        data-id="{{ $video->id }}" data-type="reject"><i
                                                        class="fa fa-times " aria-hidden="true"></i></button>

                                                <button data-toggle="tooltip" data-placement="right"
                                                        title="Slet Video" class="vd_act statusdeactive"
                                                        data-reason="yes" data-id="{{ $video->id }}"
                                                        style="{{($video->status=='pending') ? 'display:none': ''}}"
                                                        data-type="remove"><i
                                                        class="fa fa-trash " aria-hidden="true"></i></button>

                                            @elseif(Auth::user()->hasRole('coach'))
                                                <button data-toggle="tooltip" data-placement="right" title="Rediger Video"
                                                        class="statusactive">
                                                    <i class="fa fa-pencil-alt edit_vid" aria-hidden="true"
                                                       data-id="{{ $video->id }}"></i></button>

                                                <button data-toggle="tooltip" data-placement="right"
                                                        title="Slet Video" class="vd_act" data-id="{{ $video->id }}"
                                                        data-reason="no" data-type="remove"><i
                                                        class="fa fa-trash " aria-hidden="true"></i></button>
                                            @endif

                                        </div>

                                    @endif
                                    @if (Auth::check())
                                        <a data-id='{{$video->video_id}}' href="#"
                                           class="color-gray-darker td-hover-none vimeo_play">
                                            @else
                                                <a data-id='login' href="#"
                                                   class="color-gray-darker td-hover-none lg_in">
                                                    @endif
                                                    <div class="ba-0 ds-1 like-content">
                                                        <div class="course-viewer">
                                                            <ul>

                                                                <li>
                                                                    {{ gmdate("H:i:s", $video->video_duration) }}
                                                                </li>
                                                            </ul>
                                                        </div>


                                                        <div
                                                            style="background-image: url({{ asset('uploads/images/'.$video->video_thumbnail) }});"
                                                            class="card-img-top"></div>
                                                        <div class="card-body">
                                                            @php
                                                                $fullName = $video->user->first_name.' '.$video->user->last_name;
                                                            @endphp
                                                            <span class="coach-name " >{!! Str::limit($fullName, 50, ' ...') !!}
                                                        </span>
                                                            <h4 class="card-title color-gray-darker">{!! Str::limit($video->video_title, 20, ' ...') !!}
                                                            </h4>
                                                            <p class="card-text color-gray-darker" >{!! Str::limit($video->video_description, 90, ' ...') !!}</p>

                                                            @if (Auth::check())
                                                                @hasanyrole($collectionOfRoles)
                                                                <div id="st-{{$video->id}}"
                                                                     class="statusv-{{($video->status=='approved' ? 'godkendt':'verserende')}} ">
                                                                    {{($video->status=='approved' ? 'godkendt':'Venter på godkendelse')}}
                                                                </div>
                                                                @endhasanyrole
                                                            @endif
                                                        </div>
                                                    </div>
                                                </a>

                                </div>
                            @endforeach


                        </div>
                    @else

                        Ingen Videoer Fundet.
                    @endif
                </div>

            </div>
            <!-- .row end -->
            <div aria-labelledby="myModalLabel" class="modal fade" id="modalYT" role="dialog" tabindex="-1"
                 style="display: none;" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-body mb-0 p-0">
                            <div class="embed-responsive embed-responsive-16by9 z-depth-1-half">
                                <iframe class="embed-responsive-item vim_iframe"
                                        src="" width="640" height="360"
                                        frameborder="0" allow="autoplay; fullscreen" allowfullscreen=""></iframe>

                            </div>
                        </div>
                        <div class="modal-footer">

                            <button class="btn-custom color-two"
                                    data-dismiss="modal" type="button">LUK
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    {{ $videos->appends($_GET)->links() }}
                </div>
            </div>

        </div>


    </div>
            </div>
@endsection



