@extends('layouts.app')
@section('content')
    <div id="UploadVideo" class="wrap-bg">

    <div class="container">

        <h3>Godkend introduktionsvideoer</h3>
        <div class="library-filter mb20">
            <div class="container">
                <form action="{{route('bo.intros.filter')}}" id="filter_form">
                    <div class="row ">

                        <div class="col-md-4 col-sm-4 mt-1 mb-1">

                            {{ Form::select('status', $statuses, isset($status) ? $status : '' , ['class' => 'form-control filter']) }}

                        </div>
                        {{--<div class="col-md-4 col-sm-4 mt-1 mb-1">
                            {{ Form::select('state', $duration, isset($state) ? $state : null , ['class' => 'form-control filter']) }}


                        </div>--}}
                    </div>
                </form>
            </div>
        </div>



        <div class="container">
            <!-- .row -->
            <div class="row">
                <div class="container mt-2 p-0">
                    @if(count($videos)>0)
                        <div class="row">
                            @foreach($videos as $video)
                                <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                                    <div class="iconsets">
                                        <button data-toggle="tooltip" data-placement="right" title="Godkend Video"  class=" statusactive int_act"
                                                style="{{($video->status=='active'? 'display:none': '')}}"
                                                data-id="{{ $video->id }}" data-type="approved"><i
                                                class="fa fa-check " aria-hidden="true"></i></button>
                                        <button data-toggle="tooltip" data-placement="right" title="Afvis Video"  class="int_act statusdeactive" style="{{($video->status=='inactive') ? '': 'display:none'}}" data-id="{{ $video->id }}" data-type="reject"><i
                                                class="fa fa-times "  aria-hidden="true"></i></button>

                                        <button data-toggle="tooltip" data-placement="right" title="Slet Video"  class="int_act statusdeactive" data-reason="yes" data-id="{{ $video->id }}"  style="{{($video->status=='inactive') ? 'display:none': ''}}" data-type="remove"><i
                                                class="fa fa-trash " aria-hidden="true"></i></button>
                                    </div>
                                    <a data-id='{{$video->video_id}}' href="#" class="color-gray-darker td-hover-none vimeo_play">
                                        <div class="ba-0 ds-1 like-content">
                                        <div class="course-viewer">
                                                    <ul>

                                                        <li>  {{ gmdate("H:i:s", $video->video_duration) }}</li>
                                                    </ul>
                                                </div>
                                            <div style="background-image: url({{ asset('uploads/images/'.$video->video_thumbnail) }});" class="card-img-top"></div>
                                            <div class="card-body">
                                                                <span class="coach-name  ">{{$video->user->first_name}} {{$video->user->last_name}}
                                                                </span>
                                                <h4 class="card-title color-gray-darker">{{$video->video_title}}
                                                </h4>
                                                <p class="card-text color-gray-darker">{!! Str::limit($video->video_description, 120, ' ...') !!}</p>
                                                <div class="course-viewer">
                                                    <ul>

                                                        <li>
                                                            {{ gmdate("H:i:s", $video->video_duration) }}
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div id="int-{{$video->id}}" class="statusv-{{($video->status=='active' ? 'approved':'pending')}}">
                                                    {{($video->status=='active' ? 'Approved':'Waiting for approval')}}
                                                </div>
                                            </div>
                                        </div>
                                    </a>

                                </div>
                            @endforeach


                    </div>
                    @else

                        Ingen introduktionsvideoer fundet!
                    @endif
                </div>

            </div>
            <!-- .row end -->
            <div aria-labelledby="myModalLabel" class="modal fade" id="modalYT" role="dialog" tabindex="-1" style="display: none;" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-body mb-0 p-0">
                            <div class="embed-responsive embed-responsive-16by9 z-depth-1-half">
                                <iframe class="embed-responsive-item vim_iframe" src="https://player.vimeo.com/video/385465662" width="640" height="360" frameborder="0" allow="autoplay; fullscreen" allowfullscreen=""></iframe>

                            </div>
                        </div>
                        <div class="modal-footer">

                            <button class="btn-custom color-two" data-dismiss="modal" type="button">LUK</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    {{ $videos->appends($_GET)->links() }}
                </div>
            </div>

        </div>


    </div>


</div>
@endsection

