
let upload              = null;
let uploadIsRunning     = false;
const uploadForm        = document.querySelector("#upload-video");
const submitBtn         = uploadForm.querySelector("#uploadButton");
let input               = uploadForm.querySelector("#uploadedVideo");
const progress          = document.querySelector(".progress");
const progressBar       = progress.querySelector(".progress-bar");
const alertBox          = document.querySelector("#support-alert");
const url               = my_vim_url;
let file                = input;
let formdata            = '';


uploadForm.addEventListener('submit', function(event)  {
    event.preventDefault();

    if ($('#uploadedVideo').val()) {
        event.preventDefault();

        new FormData(uploadForm)

        //startUpload()
    }

    return false;
});

uploadForm.addEventListener('formdata', function(event)  {
    formdata = event.formData;
});

input.addEventListener('change',  function(event)  {
    // Get the selected file from the input element
    file = event.target.files[0]
});



function printErrorMsg (msg) {
    $(".print-error-msg").find("ul").html('');
    $(".print-error-msg").css('display','block');
    $.each( msg, function( key, value ) {
        $(".print-error-msg").find("ul").append('<li>'+value+'</li>');
    });
}
function startUpload() {

    $('#buttonsbar').slideUp();
    $('#progressBarWrapper').slideDown();
    $.LoadingOverlay("show");
    const xhr = new XMLHttpRequest();
    //console.log(url);
    xhr.open('POST', url, true)
    xhr.setRequestHeader('Authorization', "Bearer "+my_vim_tkn)
    xhr.setRequestHeader('Content-Type', 'application/json')
    xhr.setRequestHeader('Accept', 'application/vnd.vimeo.*+json;version=3.4')
    xhr.onload = function(event) {

        if (event.target.status < 400) {

            const response = JSON.parse(event.target.responseText)

            // Create a new tus upload
            upload = new tus.Upload(file, {
                uploadUrl: response.upload.upload_link,
                retryDelays: [0, 1000, 3000, 5000],
                metadata: {
                    filename: file.name,
                    filetype: file.type,
                },
                onError: function(error) {
                    //console.log("Failed because: " + error);
                    $('#buttonsbar').slideDown();
                    $('#progressBarWrapper').slideUp();
                    $.LoadingOverlay("hide");
                },
                onProgress: function(bytesUploaded, bytesTotal) {
                    let percentage = (bytesUploaded / bytesTotal * 100).toFixed(2);
                    //console.log(bytesUploaded, bytesTotal, percentage + "%");

                    progressBar.innerHTML = percentage + "%";
                    progressBar.style.width = percentage + "%";
                },
                onSuccess: function() {
                    console.log('Before SUbmitting Form');
                    console.log(response);
                    //console.log("Success! Download %s from %s", upload.file.name, upload.url)
                    $("#succesMsg").fadeIn();
                    //$('#loader-icon').hide();
                    $('input[name="uri"]').val(response.uri)

                    var formD = $('#upload-video').serializeArray();
                    var formN = new FormData();


                    $(formD).each(function(i, field){
                        formN.append(field.name,field.value);
                    });

                    //var data = {};
                    $.each($('#thumbnail')[0].files, function(i, file) {
                        formN.append('thumbnail',file);
                    });


                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: site_config.base_url + "/video/upload/submit",
                        data:  formN,
                        type: 'POST',
                        processData: false,
                        contentType: false,
                        success: function (data) {
                            $.LoadingOverlay("hide");
                            if($.isEmptyObject(data.error)){
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success!',
                                    html: '<p>Video is uploaded and sent for review!</p>' +
                                        '<a class="color-two btn-custom " href="' + site_config.base_url + '/video/upload">Upload another Video</a>',

                                    onDestroy: function() {
                                        window.location = site_config.base_url+'/coach/profile';
                                    }

                                });
                            }else{
                                $('#buttonsbar').slideDown();
                                $.LoadingOverlay("hide");
                                $('#progressBarWrapper').slideUp();
                                printErrorMsg(data.error);
                            }

                        }, error: function (data) {
                            $.LoadingOverlay("hide");
                            Swal.fire(
                                'Error!',
                                data.message,
                                'error'
                            )
                        }
                    });


                    //reset();
                }
            })

            // Start the upload
            upload.start()
            uploadIsRunning = true;

        } else {
            $.LoadingOverlay("hide");
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: 'There is some error while uploading your video, Please try again!'

            });
        }
    }.bind(this)

    xhr.send(
        JSON.stringify({
            upload:{
                approach: 'tus',
                size: file.size,
            },
            name: $('#video_title').val(),
            description: $('#video_description').val(),
            privacy: {
                "view": 'anybody',
                'comment': 'nobody'
            },
            // privacy: {
            //     "view": 'nobody',
            //     'download' : false,
            //     'embed': 'whitelist',
            //     'comment': 'nobody'
            // },
            // embed: {
            //     buttons: {
            //         like: false,
            //         share: false,
            //         embed: false,
            //         watchlater: false,
            //     }
            // },
            //language: formdata.get('language'),
            // channel: {
            //     name: 'Test1',
            //     privacy: 'user'
            // },
            // formdata.getAll('videoCategory[]')
        })
    );
}
function reset() {
    input.value = "";
    submitBtn.textContent = "start upload";
    upload = null;
    uploadIsRunning = false;
}
