<?php

namespace App\Providers;

use Illuminate\Support\Arr;
use Illuminate\Support\ServiceProvider;
use Validator;
use App\User;
use DB;
use Illuminate\Pagination\Paginator;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Validator::extend('alpha_spaces', function($attribute, $value)
        {
            return preg_match('/^[\pL\s]+$/u', $value);
        });

        Validator::extend('secure_password', function($attribute, $value)
        {
            return preg_match('/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/', $value);
        });

        Validator::extend('ref_invite_code', function ($attribute, $value) {
            $adminUsers = User::role('superadmin')->with('coachInfo')->get();
            $adminUsersCode = Arr::pluck($adminUsers, 'coachInfo.invite_code');

            if(in_array($value, $adminUsersCode) ) {
                    return false;
            }else {
                $codeFilter = function ($q) use ($value) {
                    $q->where('invite_code', $value);
                };
                $counter = User::whereHas('coachInfo', $codeFilter)->get()->count();
                return ($counter > 0) ? true : false;
            }
        });

        Validator::extend('ref_coach_invite_code', function ($attribute, $value) {
            $memberUsers = User::role('user')->with('coachInfo')->get();
            $memberUsersCode = Arr::pluck($memberUsers, 'coachInfo.invite_code');
            if(in_array($value, $memberUsersCode) ) {
                return false;
            }else {
                $codeFilter = function ($q) use ($value) {
                    $q->where('invite_code', $value);
                };
                $counter = User::whereHas('coachInfo', $codeFilter)->get()->count();
                return ($counter > 0) ? true : false;
            }
        });

        Validator::extend('recaptcha', 'App\\Validators\\ReCaptcha@validate');

    }
}
