<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;
use App\Video;


class VideoRejected extends Mailable
{
    use Queueable, SerializesModels;

    public $first_name;
    public $last_name;
    public $content;
    public $video_title;
    public $type;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Video $video,$content)
    {
        //
        $this->first_name = $video->user->first_name;
        $this->last_name = $video->user->last_name;
        $this->video_title = $video->video_title;
        $this->content = $content;
        $this->type = 'video';
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject(($this->type=='intro') ? 'Introductory ':''.'Video Rejected')->view('emails.video_rejected');
    }
}
