<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Traits\HasRoles;

class MixedMiddleware
{
    use AuthenticatesUsers;
    use HasRoles;
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::guest()) {
            return redirect()->route('home.front');
        }

        if (! Auth::user()->hasAnyRole(['coach','superadmin'])) {
            return redirect()->route('home.front');
        }

        $permissions = Auth::user()->getPermissionNames()->toArray();

        if(in_array('is_am',$permissions)) {
            /*$menu = '<li class="subnav"><a href="#">My Admin Panel</a>
                            <ul class="sub-menu">
                                <li><a href="'.route('am.videos').'" class="nav-link ">Approve videos </a></li>
                                <li><a href="'.route('am.coaches').'" class="nav-link ">Coach Applications </a></li>
                                <li><a href="'.route('am.intros').'" class="nav-link ">Approve introductory videos </a></li>
                            </ul>
                        </li>';*/
            session(['menu' => true]);
        }

        return $next($request);
    }
}
