<?php

namespace App\Http\Controllers;
use App\Jobs\RenewNotification;
use App\Mail\ContactUs;
use App\Staff;
use App\User;
use App\UserPackage;
use Carbon\Carbon;
use App\SitePages;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Vimeo;
use Illuminate\Support\Facades\Mail;
use App\Mail\PaymentProcessed;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function __construct()
    {
       // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
/*        $userData = User::with(['coachInfo'])->find(556);
        $allChilds = $userData->coachInfo->getAllCompanyParents();
        return $allChilds;*/
        //return Carbon::now();

        return view('pages/home');
    }

    public function coach()
    {
        return view('pages/coach');
    }


    public function coaches()
    {
        return view('common/coaches');
    }

    public function videos()
    {
        return view('pages/videos');
    }

    public function questions()
    {
        return view('coaches/questions');
    }


    public function page(Request $request, $slug1 = false)
    {


        $data['page'] = SitePages::where('slug', $slug1)->first();




        if( is_null($data['page']))
        {

            return redirect()->route('home.front');
        }
        //about page, adding staff
        if($data['page']->id=='4') {
            $data['staff'] = Staff::get();
        }
        //return $data;
        return view('pages.site_page',$data);

    }


    public function contact(Request $request)
    {





        return view('pages.contact');

    }


    public function contactSubmit(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'message' => 'required',
            'captcha' => 'required|captcha'
        ]);

        $adminEmails = User::role('superadmin')->pluck('email');

        Mail::to($adminEmails)->send(new ContactUs(['name' => $request->input('name'),'email' => $request->input('email'),'message' => $request->input('message')]));
        return back()->with('success', 'Thanks for contacting us!');
    }






}
