<?php

namespace App\Http\Controllers\Coach;

use App\CoachIntro;
use App\Mail\PasswordUpdate;
use App\Mail\VideoUpload;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\User;
use App\Video;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Spatie\Permission\Traits\HasRoles;
use App\Traits\UploadTrait;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\File;
use App\Tag;
use DB;
use Illuminate\Support\Facades\Config;
use App\QuestionReplies;
use App\Question;

use Vimeo;
use Spatie\Image\Exceptions\InvalidManipulation;
use Spatie\Image\Image;
use Spatie\Image\Manipulations;


class VideoController extends Controller
{

    protected $user;
    use UploadTrait;
    use HasRoles;

    public function __construct()
    {

    }

    protected function editvalidator(array $data)
    {
        return Validator::make($data, [
            'video_title' => 'required',
            'video_description' => 'nullable',
        ]);
    }


    public function index($id=false)
    {

        if($id && is_numeric($id)) {
            $data['question_id'] = $id;
        }
        $data['categories'] = DB::table('categories')->where('status', 'active')->orderBy('title','asc')->pluck( 'title','id');
        $data['languages'] = Config::get('iviggo.languages');

        $this->user = Auth::user();
        //$records = CoachIntro::where('created_user_id', $this->user->id)->count();

        $data['vimeo_url'] = env('VIMEO_URL');
        //return $data;
        return view('videos.upload',$data);
    }

    public function edit(Request $request)
    {
        $id = $request->id;
        if( !is_numeric($id) )
        {
            return redirect()->route('videos')->with('error', 'invalid record id!');
        }

        $data['categories'] = DB::table('categories')->where('status', 'active')->orderBy('title','asc')->pluck( 'title','id');
        $data['languages'] = Config::get('iviggo.languages');

        $this->user = Auth::user();
        $tagsFilter = function ( $q){
            $q->select('tags.id','tags.title');
        };

        $catFilter = function ( $q){
            $q->select('categories.id','categories.title');
        };


        $data["rec"] = Video::with(['Tags'=>$tagsFilter,'Categories'=>$catFilter])->where(['id'=>$id,'created_user_id'=>$this->user->id])->whereIn('status',['approved','pending'])->get()->first();
       // return $data;
        if(!isset($data["rec"]->id)) {
            return redirect()->back()->with("error", "Video not found");
        }

        if($data['rec']->Tags && $data['rec']->Tags->count()>0) {

            foreach($data['rec']->Tags as $tag) {
                $data['video_tags'][] = trim($tag->title);
            }
            $data['video_tags'] = implode(',',$data['video_tags']);
        }


       // return $data;

        return view('coaches.video_edit',$data);
    }




    public function submit(Request $request)

    {


        // {"vimeo_url":"https:\/\/api.vimeo.com\/me\/videos","video_title":"AA","video_description":"AA","tags":["abc,hfd"],"video_language":"en","video_category":["6","5","2"],"uri":"\/videos\/438703766","videoLength":"0","uploadedVideo":{},"thumbnail":{}}
        $this->user = Auth::user();
        $validator = Validator::make($request->all(), [
            'video_title' => 'required',
            'video_language' => 'required',
            'video_category' => 'required|array|min:1',
            'tags' => 'nullable',
            'video_description' => 'nullable|string',
            'video_duration' => 'required|string',
            'uri' => 'required',
            'thumbnail' => 'nullable|file|mimes:jpeg,png,jpg|max:2048|dimensions:min_width=500,min_height=350',
        ],[
            'thumbnail.dimensions' => 'Image dimensions should not be less then 500px X 350px.',

        ]);

        if ($validator->passes()) {
            $this->default_condition = ["created_user_id" => $this->user->id, "updated_user_id" => $this->user->id];

            //return $fi
            if ($request->has('thumbnail')) {

                $image = $request->file('thumbnail');

                $image_name = time() . '.' . $image->getClientOriginalExtension();
                if (! File::exists(public_path('/uploads/thumbs/'))) {
                    File::makeDirectory(public_path('/uploads/thumbs/'));
                }

                $destinationPath = public_path('/uploads/images/');

                $resize_image = Image::load($image->getRealPath());

                //$resize_image->fit(Manipulations::FIT_FILL,263,148)->background('ffffff')->save($destinationPath . '263_' . $image_name);
                $resize_image->width(470)->save($destinationPath . $image_name);

                $data['video_thumbnail'] = $image_name;
            }

            $array = explode('/', $request->input('uri'));
            $vimeoVidId = $array[2];
            $data['video_title'] = $request->input('video_title');
            $data['video_description'] = $request->input('video_description');
            $data['video_id'] = $vimeoVidId;
            $data['video_duration'] = round($request->input('video_duration'), 0);
            $data['visibility'] = 'public';
            $data['language'] = $request->input('video_language');
            $data['status'] = 'pending';
            $data['created_user_id'] = $this->user->id;
            $data['updated_user_id'] = $this->user->id;


            //return $data;
            $videoUpload = Video::create($data);
            $videoUpload->categories()->sync($request->input('video_category'));
            if(!empty($request->input('tags'))) {
                $tagsInput = explode(',',$request->input('tags'));
                $tagIds = [];
                foreach($tagsInput as $tag) {
                    $tagRec = Tag::firstOrCreate(
                        ['title' => trim($tag)],
                        $this->default_condition
                    );


                    $tagIds[] = $tagRec->id;

                }

                $videoUpload->tags()->sync($tagIds);
            }

            if ($request->has('question_id')) {
                $qid = $request->input('question_id');
                $question = Question::where('id',$qid)->get()->first();
                if(isset($question->id)) {
                    QuestionReplies::firstOrCreate(
                        ['question_id' => trim($qid), 'video_id'=>$videoUpload->id, 'coach_id'=>$this->user->id, 'status'=>'read']
                    );
                }

            }


            $response['status'] = 'success';
            $response["message"] = "Video Added.";

            $managers = User::select(['id','first_name', 'last_name','email','status','created_at'])->role(['superadmin'])->where('status','active')->get();

            if( $managers && count($managers) > 0 )
            {
                foreach($managers as $manager)
                {
                    Mail::to($manager->email)->send(new VideoUpload($this->user));
                }
            }
            $code = 200;

            return response()->json($response);
        }

        return response()->json(['error'=>$validator->errors()->all()]);


        //return redirect('/coach/profile')->with('status', 'Profile updated!');


    }


    public function update(Request $request) {

        $id = $request->id;
        if( !is_numeric($id) )
        {
            return redirect()->route('videos')->with('error', 'invalid record id!');
        }


        $validator = Validator::make($request->all(), [
            'video_title' => 'required',
            'video_language' => 'required',
            'video_category' => 'required|array|min:1',
            'tags' => 'nullable',
            'video_description' => 'nullable|string',
            'thumbnail' =>  'nullable|image|mimes:jpeg,png,jpg|max:2048|dimensions:min_width=500,min_height=350',
        ],[
            'thumbnail.dimensions' => 'Image dimensions should not be less then 500px X 350px.',

        ]);


        $this->user = Auth::user();

        $video = Video::where('id', $id)->get()->first();
        if($this->user->id!=$video->created_user_id) {
            return redirect()->route('videos')->with('error', 'you are not authorized to perform this action!');
        }
        if ($validator->passes()) {


            if ($request->has('thumbnail')) {


                // Get image file
                $image = $request->file('thumbnail');

                $image_name = time() . '.' . $image->getClientOriginalExtension();

                if (! File::exists(public_path('/uploads/thumbs/'))) {
                    File::makeDirectory(public_path('/uploads/thumbs/'));
                }

                if (! File::exists(public_path('/uploads/images/'))) {
                    File::makeDirectory(public_path('/uploads/images/'));
                }

                $destinationPath = public_path('/uploads/images/');

                $resize_image = Image::load($image->getRealPath());

                $resize_image->width(470)->save($destinationPath . $image_name);


                $video->video_thumbnail = $image_name;
                $video->vimeo_callback = 'done';

            }


            $video->video_title = $request->input('video_title');
            $video->video_description = $request->input('video_description');
            $video->language = $request->input('video_language');
            $video->save();
            //return $data;
            $video->categories()->sync($request->input('video_category'));
            $this->default_condition = ["created_user_id" => $this->user->id, "updated_user_id" => $this->user->id];
            if(!empty($request->input('tags'))) {
                $tagsInput = explode(',',$request->input('tags'));
                $tagIds = [];
                foreach($tagsInput as $tag) {
                    $tagRec = Tag::firstOrCreate(
                        ['title' => trim($tag)],
                        $this->default_condition
                    );


                    $tagIds[] = $tagRec->id;

                }

                $video->tags()->sync($tagIds);
            }
            //return redirect('/my/videos')->with('status', 'video updated successfully.!');
            return redirect('/coach/profile')->with('status', 'video updated successfully.!');
        }


    }

    public function delete($id) {
        $this->user = Auth::user();

        $rec = CoachIntro::where('id', $id)->get()->first();
        if(!isset($rec->id)) {
            return redirect()->back()->with("error", "Video not found");
        }
        if($rec->created_user_id==$this->user->id) {




            $array = explode('/', $rec->video_id);
            $response = Vimeo::request($rec->video_id, ['video_id'=>$array[2]],'Delete');

            CoachIntro::where('id', $id)->delete();
            return redirect('/coach/profile')->with('success', 'intro video deleted!');
        }else{


            return redirect()->back()->with("error", "Record cannot be deleted");
        }
    }
}
