<?php

namespace App\Http\Controllers\Bo;

use App\CoachProfileInfo;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Countries;
use App\User;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Input;
use Spatie\Permission\Traits\HasRoles;
use App\Traits\UploadTrait;
use Illuminate\Database\Eloquent\Builder;
use Carbon\Carbon;
use DB;
use App\Video;
use App\CoachIntro;





class VideoController extends Controller
{

    protected $user;
    use UploadTrait;
    use HasRoles;

    public function __construct()
    {

    }

    public function index(Request $request)
    {
        $data = $request->all();
        $this->user = Auth::user();
        //$data["user"] = User::with(['coachInfo'])->get();

        $data['categories'] = DB::table('categories')->where('status', 'active')->orderBy('title','asc')->pluck( 'title','id')->toArray();
        $languages = Config::get('iviggo.languages');
        /*$data['statuses'] = ['2'=>'Pending','1'=>'Approved'];*/
        $data['duration'] = [null=>'Newest','2'=>'One Month Old','1'=>'Recent'];


       //return $data;
        $userFilter = function ( $q){
            $q->where('status', 'active');
        };
        $videos = Video::with(['user'=>$userFilter])->whereHas('user',$userFilter);

        $filtersOptions  =  $videos->get();



        $video_languages = array_unique(Arr::pluck($filtersOptions,'language'));
        $data['languages'] = [];
        foreach($video_languages as $key)
        {
            if(array_key_exists($key, $languages))
            {
                $data['languages'][$key] = $languages[$key];
            }
        }

        if(count($data['languages'])==0) {
            $data['languages'] = $languages;
        }

        if ($request->has('category') && !empty($request->category)) {
            $data['category'] = $request->category;
            $countryFilter = function ( $q) use($request){
                $q->where('category_id', $request->category);
            };
            $videos =$videos->with(['Categories'=>$countryFilter])->whereHas('Categories',$countryFilter);

        }

        if ($request->has('language') && !empty($request->language)) {
            $data['language'] = $request->language;
            $videos =$videos->where('language',$request->language);

        }


        if ($request->has('status') && !empty($request->status)) {
            $data['status'] = $request->status;
            $videos =$videos->where('status',(($request->status=='1') ? 'approved':'pending'));

        } else {
            $videos =$videos->where('status','pending');
        }


        /*if ($request->has('state') && !empty($request->state)) {
            $data['state'] = $request->state;
            if($request->state=='2') {
                $videos =$videos->where('created_at','>', Carbon::now()->subDays(30));
            }
            if($request->state=='1') {
                $videos =$videos->where('created_at',Carbon::today());
            }


        }*/


        $videos = $videos->orderBy('created_at', 'desc')->paginate(16);
        $data["videos"] = $videos;
        //return $data;
        return view('common.video_library', $data);
    }

    public function intros(Request $request)
    {
        $data = $request->all();
        $this->user = Auth::user();
        //$data["user"] = User::with(['coachInfo'])->get();


        $data['statuses'] = [''=>'All','2'=>'Pending','1'=>'Approved'];
        $data['duration'] = [null=>'Newest','2'=>'One Month Old','1'=>'Recent'];

        //return $data;
        $userFilter = function ( $q){
            $q->where('status', 'active');
        };
        if($this->user->hasRole('superadmin')) {
            $videos = CoachIntro::with(['user'=>$userFilter])->whereHas('user',$userFilter);
        } else {
            $coachTree = new CoachProfileInfo();
            $childUsers = $coachTree->allTree(CoachProfileInfo::where('created_user_id',$this->user->id)->first());
            $videos = CoachIntro::with(['user'=>$userFilter])->whereHas('user',$userFilter)->whereIn('created_user_id',$childUsers);
        }




        if ($request->has('status') && !empty($request->status)) {
            $data['status'] = $request->status;
            $videos =$videos->where('status',(($request->status=='1') ? 'active':'inactive'));

        }


        if ($request->has('state') && !empty($request->state)) {
            $data['state'] = $request->state;
            if($request->state=='2') {
                $videos =$videos->where('created_at','>', Carbon::now()->subDays(30));
            }
            if($request->state=='1') {
                $videos =$videos->where('created_at',Carbon::today());
            }


        }


        $videos = $videos->orderBy('created_at', 'desc')->paginate(128);
        $data["videos"] = $videos;

        return view('bo.intros', $data);
    }

    public function profile($id) {
        if(!$id || !is_numeric($id))
        {
            return redirect()->route( 'bo.dashboard');
        }

        $data["user"] = User::with(['coachInfo','coachIntro'])->where('id', $id)->get(['id', 'first_name','last_name', 'email'])->first();
        return view('bo.pages.profile', $data);
    }


}
