<?php

namespace App\Http\Controllers\Bo;

use App\Presentation;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Spatie\Permission\Traits\HasRoles;
use App\SitePages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

use Auth;



class SitePagesController extends Controller
{
    use HasRoles;

    public function __construct()
    {
        $this->middleware(['auth', 'isSuper']);

    }

    protected function editvalidator(array $data,$id)
    {
        return Validator::make($data, [
            'title' => 'required|max:200',
            'content' => 'required',
            'type'=> 'required'
        ], [
            'title.max' => 'Title must not exceed 200 characters'
        ]);
    }

    protected function addvalidator(array $data)
    {
        return Validator::make($data, [
            'title' => 'required|max:200',
            'slug' => 'required|regex:/^[a-zA-Z0-9\-]+$/|unique:site_pages',
            'content' => 'required',
        ], [
            'title.max' => 'Title must not exceed 200 characters'
        ]);


    }

    public function index()
    {
        $pages = SitePages::orderby('id', 'ASC')->get();
        $presentations = Presentation::orderby('id', 'ASC')->get();
        return view('bo.pages',['pages'=>$pages,'presentations'=>$presentations]);
    }

    public function edit($id,$type='site')
    {

        if($type=='mkt') {
            $page = Presentation::where('id', '=', $id)->get()->first();
        } else {
            $page = SitePages::where('id', '=', $id)->get()->first();
        }


        return view('bo.edit_page',['page'=>$page,'type'=>$type]);
    }

    public function submit(Request $request)
    {

        $this->user = Auth::user();
        $presentationImage = '';
        if ($request->has('photo')) {

            $this->validate($request,[

                'photo' =>  'image|mimes:jpeg,png,jpg|max:2048',

            ]);
            // Get image file
            $image = $request->file('photo');

            $image_name = time() . '.' . $image->getClientOriginalExtension();


            if (! File::exists(public_path('/uploads/images/'))) {
                File::makeDirectory(public_path('/uploads/images/'));
            }

            $destinationPath = public_path('/uploads/images/');

            $image->move($destinationPath, $image_name);


            $presentationImage = $image_name;

        }

        $this->editvalidator($request->all(),$request->input('id'))->validate();
        if($request->input('type') == 'mkt') {
            $page = Presentation::find($request->input('id'));
            if(!empty($presentationImage)) {
                $page->presentation_image = $presentationImage;
            }

        } else {
            $page = SitePages::where('id', $request->input('id'))->get(['id'])->first();
        }

        $page->title = $request->input('title');
        $page->content = $request->input('content');
        $page->created_user_id = $this->user->id;
        $page->updated_user_id = $this->user->id;

        $page->save();


        return redirect(route('bo.pages'));
    }

}
