<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Mail\RemindGiftEmail;
use App\UserPackage;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use Spatie\Permission\Traits\HasRoles;

class GiftReminder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'remind:gift';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send Signup reminder notification 1, 3, 7 days';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $userPackages = UserPackage::with(['user'=> function ($q) {
            $q->withTrashed();
        }, 'plan'])->where(['status'=>'inactive','cancels_at'=>NULL, 'canceled_at'=>NULL])->whereDate('validity_date', '=', Carbon::now()->addDays(7))->get();
        
        if($userPackages->count() > 0) {

            foreach($userPackages as $item) {
                if(is_null($item->user->deleted_at) && $item->user->hasRole('user')) {
                    $details = ['record' => $item, 'days'=>7, 'url'=>route('giftuser.signup.create',['user_id'=>$item->created_user_id]),'email'=>$item->user->email];
                    Mail::to($item->user->email)->send(new RemindGiftEmail($details));
                }
            }
        }

        $userPackages = UserPackage::with(['user'=> function ($q) {
            $q->withTrashed();
        }, 'plan'])->where(['status'=>'inactive','cancels_at'=>NULL, 'canceled_at'=>NULL])->whereDate('validity_date', '=', Carbon::now()->addDays(3))->get();
        
        if($userPackages->count() > 0) {

            foreach($userPackages as $item) {
                if(is_null($item->user->deleted_at) && $item->user->hasRole('user')) {
                    $details = ['record' => $item, 'days'=>3, 'url'=>route('giftuser.signup.create',['user_id'=>$item->created_user_id]),'email'=>$item->user->email];
                    Mail::to($item->user->email)->send(new RemindGiftEmail($details));
                }
            }
        }

        $userPackages = UserPackage::with(['user'=> function ($q) {
            $q->withTrashed();
        }, 'plan'])->where(['status'=>'inactive','cancels_at'=>NULL, 'canceled_at'=>NULL])->whereDate('validity_date', '=', Carbon::now()->addDays(1))->get();
        
        if($userPackages->count() > 0) {

            foreach($userPackages as $item) {
                if(is_null($item->user->deleted_at) && $item->user->hasRole('user')) {
                    $details = ['record' => $item, 'days'=>1, 'url'=>route('giftuser.signup.create',['user_id'=>$item->created_user_id]),'email'=>$item->user->email];
                    Mail::to($item->user->email)->send(new RemindGiftEmail($details));
                }
            }
        }

    }
}
