@extends('layouts.app')
@section('content')

    <!-- UploadVide area start -->
    <div id="UploadVideo" class="wrap-bg">
        <div class="container">

            <div class="row mb-4">
                <div class="col-md-6 col-sm-12"><h3>Upload video</h3></div>
                <div class="col-md-6 col-sm-12"><a href="{{route("cms.page", ["slug" => 'video-upload-guide'])}}"
                                                   target="_blank" class="color-two btn-custom uploadguide">Guide til at uploade en video</a>
                    <span class="horizonv">Optag altid dine videoer i vandret position</span>
                </div>


            </div>
            <form method="post" enctype="multipart/form-data" id="upload-video"
                  action="{{ route('video.upload.submit') }}" data-type="coach">

                {{ csrf_field() }}
                <input type="hidden" name="vimeo_url" id="vm_url" value="{{$vimeo_url}}">
                <input type="hidden" name="video_duration" id='vid_duration' value="100">
                <input type="hidden" name="uri" value="100">
                <input type="hidden" name="selfThumb" id="selfThumb">
                @if(isset($question_id))
                    <input type="hidden" name="question_id" id="question_id" value="{{$question_id}}">
                @endif
                <div class="row">


                    <div class="col-md-7 ">


                        <div class="alert alert-danger print-error-msg" style="display:none">
                            <ul></ul>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <label for="first_name" class="required">Titel</label>
                                <input id="video_title" name="video_title" class="form-control" type="text"
                                       maxlength="125">
                            </div>

                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-12">

                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Beskrivelse</label>
                                    <textarea class="form-control" id="video_description" rows="3"
                                              name="video_description"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <label for="tags" class=" ">Tags</label>
                                <input type="text" name="tags" data-role="" value=" " class="tagsinput">
                            </div>

                        </div>

                        <div class="form-group ">
                            <label for="language" class="required">Vælg sprog</label>

                            {{ Form::select('video_language', [null=>'Vælg'] + $languages, old('video_language') , ['class' => 'form-control','required']) }}
                        </div>

                        <div class="form-group">
                            {{--<label for="Categories" class="required">Vælg kategorier (maks. 6 kategorier)</label>--}}
                            {{ Form::select('video_category[]', $categories, old('video_category') , ['class' => 'form-control chosen-select v_cat ','id'=>'u_category','multiple'=>'multiple', 'required']) }}

                        </div>


                        <div class="progress" id="progressBarWrapper">
                            <div id="progressBar"
                                 class="progress-bar progress-bar-striped progress-bar-animated"
                                 role="progressbar"
                                 aria-valuenow="0"
                                 aria-valuemin="0"
                                 aria-valuemax="100"></div>
                        </div>
                    </div>
                    <div class="col-md-5  ">


                        <div class="frame">
                            <div class="center">


                                <div class="dropzone">
                                    <img src="{{ asset('images/upload_video.png') }}" class="upload-icon">

                                </div>
                                <div class="input-file-container">
                                    <input class="input-file" name="uploadedVideo" id="uploadedVideo" type="file"
                                           accept="video/*">
                                    <label tabindex="0" for="my-file" class="input-file-trigger">Vælg Video
                                        Fil</label>
                                </div>
                                <small>maksimal filstørrelse er 512mb</small>
                                <span>(ideelt set op til 5 minutters video)</span>
                                <p class="file-return"></p>
                                <small><span style="color:red;">Bemærk:</span>Thumbnail kan tage 2-3 minutter at
                                    komme til syne</small>

                            </div>
                        </div>


                        <div class="form-group text-picupload">


                            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 upload_pictures">
                                <div class="filethumb"><label for="files">Hvis det er nødvendigt, kan du uploade en brugerdefineret
                                        thumbnail</label>
                                    <input type="file" id="thumbnail" accept="image/jpg,image/jpeg" name="thumbnail" data-imageWidth="500" data-imageHeight="350">
                                    <div>
                                        <small>Minimum billedopløsning er 500 x 350<br>
                                            Maksimal billedstørrelse er 2mb<br>
                                            Kun JPG-format er tilladt</small>
                                    </div>
                                    <img src="" id="img1">

                                </div>
                            </div>


                        </div>

                    </div>
                    <div class="form-row pt-3 pl-3" id="buttonsbar">
                        <input type="submit" class="color-two btn-custom " id="uploadButton" value="Upload">
                    </div>
                </div>

            </form>
        </div>
        <!-- questionbox area end -->


    </div>


    <!-- Upload Video area end -->
@endsection
@push('styles')
    <link rel="stylesheet" href="/css/tagsinput.css">
@endpush
@push('scripts')
    <script>
        // create the video element but don't add it to the page
        var vid = document.createElement('video');
        var canv = document.createElement('canvas');
        document.querySelector('#uploadedVideo').addEventListener('change', function () {
            // create url to use as the src of the video
            var fileURL = URL.createObjectURL(this.files[0]);
            vid.src = fileURL;
            // wait for duration to change from NaN to the actual duration
            vid.ondurationchange = function () {
                if (this.duration != '' || this.duration != '0') {
                    document.getElementById('vid_duration').value = this.duration;

                }

            };
        });




    </script>
    <script>
        let my_vim_url = '{{ env('VIMEO_URL') }}';
        let my_vim_tkn = '{{ env('VIMEO_ACCESS') }}';
    </script>
    <script src="/js/upload.js"></script>
@endpush
