$(document).ready(function ($) {

	'use strict';

	// Script for Header Background - Height 100% //
	if ($(document).width() >= 769) {
		$(window).on("resize", function () {
			if ($(window).width() < 769) {
				$('.header-content').height("auto"); // Mobile version size "auto"
			} else {
				var height = $(window).height(); //Get the height of the browser window
				$('.header-content').height(height - 150); //Resize the videocontainer div, with a size of 64 - page height.
			}
		}).resize();
	} else {}
	// End Script for Header Background - Height 100% //


	// jQuery smooth scrolling //
	$('a[href*="#"]').on('click', function (e) {
		e.preventDefault();
		var target = this.hash;
		var $target = $(target);
		$('html, body').stop().animate({
			'scrollTop': $target.offsetTop
		}, 900, 'swing', function () {
			window.location.hash = target;
		});
	});


	// End jQuery smooth scrolling //

	jQuery(document).ready(function ($) {
		// Scroll to top button
		// browser window scroll (in pixels) after which the "back to top" link is shown
		var offset = 300,
			//browser window scroll (in pixels) after which the "back to top" link opacity is reduced
			offset_opacity = 1200,
			//duration of the top scrolling animation (in ms)
			scroll_top_duration = 700,
			//grab the "back to top" link
			$back_to_top = $('.cd-top');

		//hide or show the "back to top" link
		$(window).scroll(function () {
			($(this).scrollTop() > offset) ? $back_to_top.addClass('cd-is-visible'): $back_to_top.removeClass('cd-is-visible cd-fade-out');
			if ($(this).scrollTop() > offset_opacity) {
				$back_to_top.addClass('cd-fade-out');
			}
		});

		//smooth scroll to top
		$back_to_top.on('click', function (event) {
			event.preventDefault();
			$('body,html').animate({
				scrollTop: 0,
			}, scroll_top_duration);
		});
		// End Scroll to top

		// Mobile Menu Show Hide Submenu
		$('#header .navbar-default li.subnav ul').after('<div class="nav__expand"><i class="fas fa-chevron-down"></i></div>');
		$("#header .navbar-default li.subnav .nav__expand").on('click', function () {
			$(this).prev("ul").slideToggle("slow");
		});
	});


	// Navigation menu scrollspy to anchor section //
	$('body').scrollspy({
		target: '#navigation .navbar-collapse',
		offset: parseInt($('#navigation').height(), 0)
	});
	// End navigation menu scrollspy to anchor section //


	// sticky-menu on scroll
	$(window).on('scroll', function () {
		var scroll = $(window).scrollTop();
		if (scroll < 150) {
			$(".sticky").removeClass("sticky-menu");
		} else {
			$(".sticky").addClass("sticky-menu");
		}
	});

	// End sticky-menu on scroll

	// Display none top bar on scroll 

	$(window).on('scroll', function () {
		var scroll = $(window).scrollTop(); 
		var innerW =  window.innerWidth
		console.log('innerW', innerW)
		if (scroll > 200 && innerW <= 900 ) {
			$(".topBar").addClass("d-none");
		} else {
			$(".topBar").removeClass("d-none");
		}
	});

	
	// Display none top bar on scroll


	/* magnificPopup image view */
	$('.popup-image').magnificPopup({
		type: 'image',
		gallery: {
			enabled: true
		}
	});
	/* End magnificPopup image view */


	/* magnificPopup video view */
	$('.popup-video').magnificPopup({
		type: 'iframe',
		gallery: {
			enabled: true
		}
	});
	/* End magnificPopup video view */


	// jQuery tooltips //
	$('.btn-tooltip').tooltip({
		trigger: 'hover'
	});
	$('.btn-popover').popover();
	// End jQuery tooltips //



	// Team Slider Slick
	$('.carousel-slider.gallery-slider').slick({
		arrows: false,
		dots: true,
		slidesToShow: 4,
		slidesToScroll: 1,
		autoplay: false,
		autoplaySpeed: 5000,
		draggable: true,
		responsive: [{
				breakpoint: 1250,
				settings: {
					slidesToShow: 3,
					draggable: true
				}
			},
			{
				breakpoint: 990,
				settings: {
					slidesToShow: 1,
					draggable: true
				}
			},
			{
				breakpoint: 767,
				settings: {
					slidesToShow: 1,
					draggable: true
				}

			}
		]
	});
	// End Team Slider Slick


	// Projects Slider Slick
	$('.carousel-slider.projects-slider').slick({
		arrows: false,
		dots: true,
		slidesToShow: 4,
		slidesToScroll: 1,
		autoplay: false,
		autoplaySpeed: 5000,
		draggable: true,
		responsive: [{
				breakpoint: 1200,
				settings: {
					slidesToShow: 3,
					draggable: true
				}
			},
			{
				breakpoint: 990,
				settings: {
					slidesToShow: 2,
					draggable: true
				}
			},
			{
				breakpoint: 767,
				settings: {
					slidesToShow: 1,
					draggable: true
				}

			}
		]
	});
	// End Projects Slider Slick

	// Sponsor Slider Slick
	$('.carousel-slider.sponsor-slider').slick({
		arrows: false,
		dots: false,
		slidesToShow: 6,
		slidesToScroll: 1,
		autoplay: false,
		autoplaySpeed: 5000,
		draggable: true,
		responsive: [{
				breakpoint: 1200,
				settings: {
					slidesToShow: 6,
					draggable: true
				}
			},
			{
				breakpoint: 990,
				settings: {
					slidesToShow: 4,
					draggable: true
				}
			},
			{
				breakpoint: 767,
				settings: {
					slidesToShow: 3,
					draggable: true
				}

			}
		]
	});
	// End Projects Slider Slick


	$(".animated-text").typed({
        strings: [
            "Motivationen?",
            "Energien?",
            "Humøret?",
            "Selvtilliden?",
            "Stressen?",
            "Eller andet?"
        ],
        typeSpeed: 40,
        loop: true,
    });

	// Students Review Slider Slick
	$('.carousel-slider.general-slider').each(function () {
		$(this).slick({
			arrows: false,
			dots: true,
			slidesToShow: 1,
			slidesToScroll: 1,
			autoplay: false,
			autoplaySpeed: 5000,
			draggable: true,
			responsive: [{
				breakpoint: 767,
				settings: {
					slidesToShow: 1,
					draggable: true
				}
			}]
		});
	});
	// End Students Review Slider Slick


	// Preview images popup gallery with Fancybox //
	$('.fancybox').fancybox({
		loop: false
	});
	// End Preview images popup gallery with Fancybox //



	// Counter animation //
	/*$('.themeioan_counter > h4').counterUp ({
		delay: 10,
		time: 3000
	});*/
	// End Counter animation //


	// Navigation Burger animation //
	$('.burger-icon').on('click touchstart', function (e) {
		$(this).toggleClass('change');
		$("#navbarCollapse").slideToggle();
		e.preventDefault();
	});
	// END Navigation Burger animation //


	// Contact form submit process //
	$('#contact-us-form').submit(function () {
		var form = $(this),
			hasError = false;

		form.find('.error-msg, .success-msg').remove();

		form.find('.required-field').each(function () {
			$(this).removeClass('not-valid');
			if ($.trim($(this).val()) === '') {
				$(this).addClass('not-valid').parent().append('<div class="error-msg">This is a required field.</div>');
				hasError = true;
			} else if ($(this).hasClass('email-field')) {
				var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
				if (!emailReg.test($.trim($(this).val()))) {
					$(this).addClass('not-valid').parent().append('<div class="error-msg">You entered an invalid Email.</div>');
					hasError = true;
				}
			}
		});
		if (!hasError) {
			var formData = $(this).serialize();
			$.post('contact-process.php', formData, function (data) {
				form.find('.required-field').val('');
				form.append('<div class="success-msg">Thank you! We will contact you shortly.</div>');
			}).fail(function () {
				//form.find('.required-field').val('');
				form.append('<div class="error-msg">Error occurred. Please try again later.</div>');
			});
		}
		return false;
	});
	// End contact form submit process //

	// Slider Home 6 - with arrows Prev Next
	$('.owl-navigation ').owlCarousel({
		loop: false,
		margin: 0,
		nav: false,
		touchDrag: false,
		mouseDrag: false,
		autoplay: false,
		autoplayTimeout: 5000,
		smartSpeed: 1000,
		autoplayHoverPause: false,
		responsive: {
			0: {
				items: 1
			}
		}
	});
	// Slider End

	// Slider Home 2
	$('.owl-carousel').owlCarousel({
		loop: false,
		margin: 0,
		nav: false,
		touchDrag: false,
		mouseDrag: false,
		autoplay: false,
		autoplayTimeout: 10000,
		smartSpeed: 1000,
		autoplayHoverPause: false,
		responsive: {
			0: {
				items: 1
			}
		}
	});
	// Slider End



});

//Typed Text Start
document.addEventListener('DOMContentLoaded', function () {

	'use strict';

	var fileInput = document.querySelector(".input-file"),
		button = document.querySelector(".input-file-trigger"),
		the_return = document.querySelector(".file-return");

	if (button != null) {

		button.addEventListener("keydown", function (event) {
			if (event.keyCode == 13 || event.keyCode == 32) {
				fileInput.focus();
			}
		});
		button.addEventListener("click", function (event) {
			fileInput.focus();
			return false;
		});
	}

	if (button != null) {
		fileInput.addEventListener("change", function (event) {
			the_return.innerHTML = this.value;
		});

	}

	if ($("#typed")[0]) {
		var typed = new Typed('#typed', {
			stringsElement: '#typed-strings',
			typeSpeed: 90,
			backSpeed: 90,
			startDelay: 1500,
			loop: true,
			loopCount: Infinity,
			onComplete: function (self) {
				prettyLog('onComplete ' + self);
			},
			preStringTyped: function (pos, self) {
				prettyLog('preStringTyped ' + pos + ' ' + self);
			},
			onStringTyped: function (pos, self) {
				prettyLog('onStringTyped ' + pos + ' ' + self);
			},
			onLastStringBackspaced: function (self) {
				prettyLog('onLastStringBackspaced ' + self);
			},
			onTypingPaused: function (pos, self) {
				prettyLog('onTypingPaused ' + pos + ' ' + self);
			},
			onTypingResumed: function (pos, self) {
				prettyLog('onTypingResumed ' + pos + ' ' + self);
			},
			onReset: function (self) {
				prettyLog('onReset ' + self);
			},
			onStop: function (pos, self) {
				prettyLog('onStop ' + pos + ' ' + self);
			},
			onStart: function (pos, self) {
				prettyLog('onStart ' + pos + ' ' + self);
			},
			onDestroy: function (self) {
				prettyLog('onDestroy ' + self);
			}
		});
	} else {
		// Do something if class does not exist
	}


});

function prettyLog(str) {}
//Typed Text End

document.querySelector("html").classList.add('js');






function readURL1(input) {
	if (input.files && input.files[0]) {
		var reader = new FileReader();
		reader.onload = function (e) {
			$('#img1').attr('src', e.target.result);
		}
		reader.readAsDataURL(input.files[0]);
	} else {
		//$('#img1').attr('src', '');
		$('#img1').css("background-image", " ");
	}
}


$("#imgInp1,#thumbnail,#photo").change(function () {
	readURL1(this);
});


$(function () {
	$('input').on('change', function (event) {

		var $element = $(event.target);
		var $container = $element.closest('.example');

		if (!$element.data('tagsinput'))
			return;

		var val = $element.val();
		if (val === null)
			val = "null";
		var items = $element.tagsinput('items');
		console.log(items[items.length - 1]);

		$('code', $('pre.val', $container)).html(($.isArray(val) ? JSON.stringify(val) : "\"" + val.replace('"', '\\"') + "\""));
		$('code', $('pre.items', $container)).html(JSON.stringify($element.tagsinput('items')));

		console.log(val);
		console.log(items);
		console.log(JSON.stringify(val));
		console.log(JSON.stringify(items));

		console.log(items[items.length - 1]);

	}).trigger('change');





});

if (typeof tinymce != 'undefined') {

	tinymce.init({
		selector: 'textarea#full-featured-non-premium',
		plugins: 'print preview paste importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists wordcount imagetools textpattern noneditable help charmap quickbars emoticons',
		imagetools_cors_hosts: ['picsum.photos'],
		menubar: 'file edit view insert format tools table help',
		toolbar: 'undo redo | bold italic underline strikethrough | fontselect fontsizeselect formatselect | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media template link anchor codesample | ltr rtl',
		toolbar_sticky: true,
		autosave_ask_before_unload: true,
		autosave_interval: "30s",
		autosave_prefix: "{path}{query}-{id}-",
		autosave_restore_when_empty: false,
		autosave_retention: "2m",
		image_advtab: true,
		content_css: '//www.tiny.cloud/css/codepen.min.css',
		link_list: [{
				title: 'My page 1',
				value: 'http://www.tinymce.com'
			},
			{
				title: 'My page 2',
				value: 'http://www.moxiecode.com'
			}
		],
		image_list: [{
				title: 'My page 1',
				value: 'http://www.tinymce.com'
			},
			{
				title: 'My page 2',
				value: 'http://www.moxiecode.com'
			}
		],
		image_class_list: [{
				title: 'None',
				value: ''
			},
			{
				title: 'Some class',
				value: 'class-name'
			}
		],
		importcss_append: true,
		file_picker_callback: function (callback, value, meta) {
			/* Provide file and text for the link dialog */
			if (meta.filetype === 'file') {
				callback('https://www.google.com/logos/google.jpg', {
					text: 'My text'
				});
			}

			/* Provide image and alt text for the image dialog */
			if (meta.filetype === 'image') {
				callback('https://www.google.com/logos/google.jpg', {
					alt: 'My alt text'
				});
			}

			/* Provide alternative source and posted for the media dialog */
			if (meta.filetype === 'media') {
				callback('movie.mp4', {
					source2: 'alt.ogg',
					poster: 'https://www.google.com/logos/google.jpg'
				});
			}
		},
		templates: [{
				title: 'New Table',
				description: 'creates a new table',
				content: '<div class="mceTmpl"><table width="98%%"  border="0" cellspacing="0" cellpadding="0"><tr><th scope="col"> </th><th scope="col"> </th></tr><tr><td> </td><td> </td></tr></table></div>'
			},
			{
				title: 'Starting my story',
				description: 'A cure for writers block',
				content: 'Once upon a time...'
			},
			{
				title: 'New list with dates',
				description: 'New List with dates',
				content: '<div class="mceTmpl"><span class="cdate">cdate</span><br /><span class="mdate">mdate</span><h2>My List</h2><ul><li></li><li></li></ul></div>'
			}
		],
		template_cdate_format: '[Date Created (CDATE): %m/%d/%Y : %H:%M:%S]',
		template_mdate_format: '[Date Modified (MDATE): %m/%d/%Y : %H:%M:%S]',
		height: 600,
		image_caption: true,
		quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
		noneditable_noneditable_class: "mceNonEditable",
		toolbar_mode: 'sliding',
		contextmenu: "link image imagetools table",
	});

}