<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;



class CreateQuickpaySubscriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quickpay_subscriptions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('subscription_id');
            $table->string('order_id');
            $table->json('metadata')->nullable();
            $table->timestamps();
            $table->string('link')->nullable();
            $table->integer('agreement_id')->nullable();
            $table->decimal('amount')->default('0.00');
            $table->decimal('vat')->default('0.00');
            $table->string('payment_methods')->nullable();
            $table->string('accepted')->nullable();
            $table->integer('created_user_id')->unsigned();
            $table->integer('user_package')->unsigned();
            $table->json('operations')->nullable();
            $table->string('state')->nullable();
            $table->softDeletes();

            $table->foreign('user_package')->references('id')->on('users_package')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('created_user_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('quickpay_subscriptions');
    }
}
