@extends('layouts.app')
@section('content')


    <!-- ApproveVideo area start -->
    <div id="UploadVideo" class="wrap-bg">

        <div class="container">

            <h3>Medlemsoplysninger</h3>

            @php
                $expiring = 'No';
                $highlight = '';
                $diffInDays = Carbon::parse(Carbon::now())->floatDiffInDays($record->ends_at,false);
                if(($diffInDays < 8)) {
                    $expiring = 'Yes';
                    if($record->recurring =='inactive') {
                       $highlight = 'class=expiring';

                   }
               }

            @endphp

            <div class="table table-responsive table-striped mb-3  ">
                <table class="table table-bordered ">
                    <thead>
                    <tr>

                        <th scope="col" width="15%">Nuværende aftale</th>
                        <th scope="col" width="10%">Pris</th>

                        <th scope="col" width="15%">Faktureringscyklus</th>
                        @if($record->state=='Approved')
                        <th scope="col" width="15%">Startdato</th>
                        <th scope="col" width="15%" {{$highlight}} data-expiring="{{$expiring}}">Slutdato</th>
                        @endif
                        <th scope="col" width="10%">Status</th>
                        <th>

                        <div class="custom-control custom-switch" width="10%">
                                <input type="checkbox" {{($record->recurring=='active') ? 'checked' : ''}} class="custom-control-input" id="recSwitch" data-id="{{$record->id}}">
                                <label class="custom-control-label" for="recSwitch">{{($record->recurring=='active') ? 'ANNULLER AUTO FORNYELSE' : 'AUTO FORNYELSE'}}</label>
                        </div>

                        </th>


                    </tr>
                    </thead>
                    <tbody>

                    <tr>

                        {{--<td>{{($record->plan->id=='1' ? 'Månedligt' : ($record->plan->id==2 ? '3 Måneders' : '12 Månedligt' )  ) }} Medlemskab</td>--}}
                        <td>{{$record->plan->title}}</td>
                        <td>kr. {{number_format($record->plan->price * $record->plan->invoice_period,2)}}</td>
                        <td>{{ucwords($record->plan->invoice_period.' '.$record->plan->invoice_interval)}}</td>
                        @if($record->state=='Approved')
                            <td scope="col">{{Carbon::parse($record->starts_at)->format('d-m-Y')}}</td>
                            <td scope="col" data-expiring="{{$expiring}}"   {{$highlight}}>{{Carbon::parse($record->ends_at)->format('d-m-Y')}}</td>

                        @endif
                        <td>{{($record->state=='Approved' && $record->status=='active') ? 'Aktiv': (empty($record->state) ? 'Afventer Dodkendelse' : ucwords($record->status))}}</td>
                        <td>

                                <a class="btn btnQbox " href="{{route('user.renew_package')}}">{{($record->state=='Approved' && $diffInDays > 0) ? 'OPGRADERING' : 'FORNYELSE'}}</a>


                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            @if(isset($record->quickpaySubscription) && $record->quickpaySubscription->count()>0)
            <h3>Transaktionshistorik</h3>
            <div class="table table-responsive table-striped mb-3 overview ">
                <table class="table table-bordered ">
                    <thead>
                    <tr>

                        <th scope="col">Dato</th>
                        <th scope="col">Total</th>

                        <th scope="col">Betalings-i</th>
                        <th scope="col">Type / Status</th>


                    </tr>
                    </thead>
                    <tbody>

                    @foreach($record->quickpaySubscription as $subscription)
                        @if(isset($subscription->quickpayPayments) && $subscription->quickpayPayments->count()>0)
                            @foreach($subscription->quickpayPayments as $payment)

                                @php
                                    if(isset($payment->operations)) {
                                    $payOperation = json_decode($payment->operations);
                                    $info = end($payOperation);
                                    } else {
                                        $info = false;
                                    }

                                if($payment->type == 'Payment' && $payment->state == 'Approved'){
                                    $payment->type = 'Betaling';
                                    $payment->state = 'Godkendt';
                                }
                                @endphp

                                <tr style="{{ $payment->type === "Refund" ? "background-color: #e4b9c0" : "" }} ">



                                    <td>{{Carbon::parse($payment->created_at)->format('d-m-Y h:i A')}}</td>
                                    <td>{{ $payment->type === "Refund" ? "-" : "" }} kr. {{ number_format(($payment->amount),2)}}</td>
                                    <td>{{$payment->payment_id}}</td>
                                    <td>{{$payment->type}} / {{$payment->state}}</td>


                                </tr>

                             @endforeach
                        @endif
                    @endforeach
                    </tbody>
                </table>
            </div>
                @endif
        </div>


    </div>

    <!-- Approve area end -->
@endsection
