@extends('layouts.marketing')
@section('content')
    @php

        $authRoles = $user->getRoleNames()->toArray();
        if(in_array('coach', $authRoles)){
             $percentageCoachArr =config('iviggo.speaker_pool');
             $percentagecoach = $percentageCoachArr['percentage'];
             $percentage = $percentagecoach;
        }else if(in_array('superadmin', $authRoles)){
             $percentageArr = config('iviggo.simon_payout');
             $percentage = $percentageArr['percentage'];
        }/*else if(in_array('user', $authRoles)){
             $percentageArr =config('iviggo.partner_payout');
             $percentage = $percentageArr['percentage'];
        }else if(in_array('is_am', $authRoles)){
             $percentageArr =config('iviggo.am_payout');
             $percentage = $percentageArr['percentage'];
        }*/

        $commission = number_format($commission,2);
        $jsCommission = round($commission,0, PHP_ROUND_HALF_DOWN);



    @endphp

    <!-- My Account -->
    <div id="Statispages" class="wrap-bg">
        <div class="container">
            <h3>My Account
            </h3>


            <div class="row ">

                <div class="container markt-account">
                    <div  >


                        <h4>Ready for payout:<span class="badge badge-secondary">€ {{$commission}}</span></h4>
                        <small class="form-text text-muted">
                            Note that it cost EUR 3 per payout -
                            <a href="#" class="text-muted" data-toggle="modal" data-target="#payoutInfoModal">
                                <i data-toggle="tooltip" data-placement="right" title="Details" class="fa fa-question-circle"></i>
                            </a>
                        </small>
                        <small class="form-text text-muted">You can payout when you have a minimum of €100 on your account.</small>
                        <form class="needs-validation" novalidate="">
                            @if(str_replace(",", "", $commission) >= config('iviggo.payout_limit'))
                                <button class="color-two disable-btn mt-3 col-md-12 col-lg-2 payoutProcess" type="button" data-details="{{$commission}}" data-id="{{$user->id}}" >Payout Now
                                </button>
                            @else
                                <button class="color-two disable-btn mt-3 col-md-12 col-lg-2" type="submit" disabled="">Payout Now
                                </button>
                            @endif

                            <button class="color-two btn-custom mt-3 col-md-12 col-lg-2" type="button" data-toggle="modal"
                                    data-target="#payoutHistoryModal">Payout History
                            </button>


                        </form>


                    </div>
                    <div class="row mt-5 my-affiliate">
                    <div class="col-lg-4 total-affi">
                    <div>My total Affiliates</div>
                    <div class="count pt-5">{{count($twoLevel)}}</div>
                    <div class="pt-3 h6">members</div>

    </div>
    <div class="col-lg-7 pl-4 text-referal"><h4>Your affiliate referral plan</h4>
    <ul>
        <li>Here you can get an overview of your referral group</li>
        <li>You receive a {{$percentage ?? '30' }}% commission every time you generate sales. </li>
        <li>And as long as the person is a member you will receive commission</li>
        <li>There is no minimum required to maintain valid iviggo Affiliate status</li>
    </ul>
</div>
</div>


                </div>
            </div>

            <div class="row">

                    <h3>See My Affiliate Referrals  </h3><div class="table-responsive mb-3 overview">
                                    <table class="table table-bordered table-responsive-stack action-it" id="tableOne">
                    <thead>
                    <tr>
                        <th>Name</th>
                        <th>Subscription</th>
                        <th>Signup Date</th>
                        <th>Active/Expired</th>

                    </tr>
                    </thead>
                    <tbody>
                    {{-- Items--}}
                    @if(isset($twoLevel) && count($twoLevel)>0)
                        @foreach($twoLevel as $item)
                            @if(empty($item->user->deleted_at))
                                @php
                                    $is_user = false;
                                    $userPackage = null;
                                    $level1Roles = $item->user->getRoleNames()->toArray();
                                    if(in_array('user',$level1Roles)) {
                                        $userPackage = \App\UserPackage::with(['plan'])->where(['created_user_id'=>$item->user->id,'status'=>'active'])->first();
                                        if(empty($userPackage)) {
                                            $package = '(Subscription Expired)';
                                        } else {
                                            if($userPackage->plan->price > 0) {
                                              if($userPackage->plan->invoice_period=='12') {
                                                    $package = '(Yearly)';
                                                } else {
                                                    $package = '(Monthly)';
                                                }
                                            } else {
                                                $package = '(Trial/Free)';
                                            }

                                        }
                                        $is_user = true;
                                    }
                                @endphp
                                <tr>
                                    <td> {{ucwords($item->user->first_name.' '.$item->user->last_name)}}</td>
                                    <td>{{(($is_user==true) ? $package : '')}}</td>
                                    <td>{{Carbon::parse($item->user->created_at)->format('d-m-Y')}}</td>
                                    <td>{{ucwords($item->user->status)}}</td>
                                </tr>
                            @endif
                        @endforeach
                    @endif

                    </tbody>
                </table>

                    {{-- End Items--}}

            </div>
                </div>
        </div>
    </div>
    <!-- My Account-->

    <input type="file" id="mediaFile" accept="image/jpeg" />
    <div class="modal fade" id="payoutInfoModal" tabindex="-1" role="dialog" aria-labelledby="payoutInfoModal"
         aria-hidden="true" style="display: none;">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Cost per payout?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>The EUR 3 per payout all goes to cover the transaction fees there's associated with a payout.
                    </p>
                    <p class="mb-0">Therefore we recommend that you wait with the payouts, until you have a decent amount. This
                        way you will not end up spending alot on transaction fees.</p>

                </div>
                <div class="modal-footer">
                    <button type="button" class="color-two btn-custom " data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="payoutHistoryModal" tabindex="-1" role="dialog" aria-labelledby="payoutHistoryModal"
         style="display: none;">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Payout History</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                        <tr>
                            <th scope="col">Transaction ID</th>
                            <th scope="col">Amount</th>
                            <th scope="col">Status</th>
                            <th scope="col">Time</th>
                        </tr>
                        </thead>
                        <tbody>
                        @if(count($payouts) > 0)
                            @foreach($payouts as $payout)
                            <tr>
                                <td>{{$payout->payout_id}}</td>
                                <td>€ {{$payout->amount}}</td>
                                <td>{{ucwords($payout->status)}}</td>
                                <td>{{Carbon::parse($payout->updated_at)->format('d-m-Y')}}</td>
                            </tr>
                            @endforeach
                            @else
                        <tr>
                            <td colspan="4">No payment history yet!</td>
                        </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="color-two btn-custom" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="ExplainCard" tabindex="-1" role="dialog" aria-labelledby="ExplainCard"
         style="display: none;">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Explain Card</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                <table class="table table-hover mb-0 ">

                        <tbody>
                        <tr>
                            <td>F</td>
                            <td>Shows the count of free members</td>

                        </tr>
<tr>
                            <td>M</td>
                            <td>Shows the count of members</td>

                        </tr>
                        <tr>
                            <td>MP</td>
                            <td>Shows the count of members partner</td>

                        </tr>

                        <tr>
                            <td>T</td>
                            <td>Shows the total count</td>

                        </tr>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="color-two btn-custom" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>


@endsection
@push('scripts')
    <script>
        $(document).ready(function () {

            $('.changedp').on('click', function(e) {
                console.log('clicked')
                $('#mediaFile').click();
            });

            $('#mediaFile').change(function(e) {

                var input = e.target;
                if (input.files && input.files[0]) {
                    var file = input.files[0];

                    let formData = new FormData();

                    formData.append('input', input.files[0], input.files[0].name)


                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        beforeSend: function () {
                            // setting a timeout
                            $.LoadingOverlay("show");
                        },

                        url: "{{route('photo.upload')}}",
                        type: "post",
                        contentType: false,
                        processData: false,
                        data: formData,
                        success: function (data) {
                            $.LoadingOverlay("hide");

                            $('.profile_tree').css("background-image", "url(" + data.image + ")");


                        }, error: function (data) {
                            $.LoadingOverlay("hide");
                            Swal.fire(
                                'Ooops!',
                                data.message,
                                'error'
                            )
                        }
                    });

                    /*var reader = new FileReader();

                    reader.readAsDataURL(file);
                    reader.onload = function(e) {
                        console.log(reader.result);
                        $('.circular--square').attr('src', reader.result);
                    }*/
                }
            });


            $(document).on('click','.payoutProcess',function(e) {
                e.preventDefault();
                var id = $(this).data('id');
                var amount = $(this).data('details');
                elem = $(this);
                Swal.fire({
                    title: 'Are you sure?',
                    text: "you want to process the payout!",
                    icon: 'question',
                    input: 'number',
                    inputValue: {{$jsCommission}},
                    inputAttributes: {
                        'min': {{config('iviggo.payout_limit')}},
                        'max': {{$commission}}
                    },
                    showCancelButton: true,
                    confirmButtonText: 'Yes!',
                    inputValidator: function(value) {
                        if (!value) {
                            return 'You need to write something!'
                        }
                    },
                }).then(function(result) {
                    if (result.value) {
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        $.ajax({
                            beforeSend: function () {
                                elem.attr('disabled',true);
                                // setting a timeout
                                $.LoadingOverlay("show");
                            },

                            url: site_config.base_url + "/payout/action",
                            type: "post",
                            data: {'id': id, 'amount': result.value},
                            success: function (data) {
                                //$.LoadingOverlay("hide");
                                location.href=data.url;

                            }, error: function (data) {

                                elem.attr('disabled',false);
                                $.LoadingOverlay("hide");
                                Swal.fire(
                                    'Ooops!',
                                    data.responseJSON.message,
                                    'error'
                                )
                            }
                        });
                    } else if (result.value == '') {
                        elem.attr('disabled',false);
                        $.LoadingOverlay("hide");

                        Swal.fire(
                            'Ooops!',
                            data.responseJSON.message,
                            'error'
                        )
                    }
                });
            });


        });


    </script>
@endpush
