<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <!-- Metas Basic -->
    <meta http-equiv="content-type" content="text/html;charset=utf-8" />
    <meta name="description"
          content="IVIGGO has a vision of developing a Danish and over time a global visual video website focusing on personal development and growth." />
    <meta name="keywords"
          content="Video coachng, Personal Development, Personal development, Self-confidence and self-esteem, Concerns and fears" />
    <meta name="author" content="Saba Qadir" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <!-- Title -->
    <title>{{ config('app.name', 'Laravel') }}</title>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">


    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ asset('images/favicon.png') }}" type="image/x-icon">

    @include('partials.app.styles')
    @stack('styles')
    <script>
        var site_config = {
            base_url: '<?= url('/') ?>'
        }
    </script>
</head>

<body>
<section class="loginpage " id="login-header">
    <div class="top-signup">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-4 col-4">
                    <div class="logo-signup "><a href="{{ url('/') }}"><img src="{{ asset('images/logo.svg') }}" alt="Logo"></a></div>
                </div>
                <div class="col-md-8 col-8 text-right">

                    <div class="custom-page-top auth-header" >
                        @if(Request::is('signup/*') || Request::is('coach/signup') || Request::is('thanks/*') || Request::is('password/*'))
                            har du allerede en bruger? <a href="{{route('login')}}" class="memberlink">Log på</a>
                        @endif

                       {{-- @if(Request::is('login'))
                                Har du ikke en konto? <a href="{{route('join')}}" class="memberlink">Kom igang</a>
                        @endif--}}
                    </div>

                </div>
            </div>

        </div>
    </div>
    @yield('content')
</section>

<!-- #footer area start -->
@include('partials.app.footer')
<!-- #footer area end -->
@include('partials.app.scripts')
@stack('scripts')
</body>

</html>


