/* global tus */
/* eslint no-console: 0 */

"use strict";

let upload          = null;
let uploadIsRunning = false;
const toggleBtn       = document.querySelector("#toggle-btn");
const input           = document.querySelector("input[type=file]");
const progress        = document.querySelector(".progress");
const progressBar     = progress.querySelector(".bar");
const alertBox        = document.querySelector("#support-alert");
const uploadList      = document.querySelector("#upload-list");
const url = 'https://api.vimeo.com/users/iviggo/videos'
let file = input;

if (!tus.isSupported) {
  alertBox.classList.remove("hidden");
}

if (!toggleBtn) {
  throw new Error("Toggle button not found on this page. Aborting upload-demo. ");
}

toggleBtn.addEventListener("click", function (e) {
  e.preventDefault();

  console.log(file)
  console.log(input.files.length)

  if (upload) {
    if (uploadIsRunning) {
      upload.abort();
      toggleBtn.textContent = "resume upload";
      uploadIsRunning = false;
    } else {
      upload.start();
      toggleBtn.textContent = "pause upload";
      uploadIsRunning = true;
    }
  } else {
    if (input.files.length > 0) {
      startUpload();
    } else {
      input.click();
    }
  }
});

function startUpload() {
  const xhr = new XMLHttpRequest()
  xhr.open('POST', 'https://api.vimeo.com/users/iviggo/videos', true)
  xhr.setRequestHeader('Authorization', 'Bearer b09934b8caddfdbceb5cc6261052ccc1')
  xhr.setRequestHeader('Content-Type', 'application/json')
  xhr.setRequestHeader('Accept', 'application/vnd.vimeo.*+json;version=3.4')
  xhr.onload = function(e) {
      if (e.target.status < 400) {
          console.log(e.target.status) //this returns status 200
          var response = JSON.parse(e.target.responseText)
          console.log(response.upload.upload_link)
          // Create a new tus upload
          var upload = new tus.Upload(file, {
              //endpoint: response.upload.upload_link,   //this looks like vimeo.api.tus... something like that
              uploadUrl: response.upload.upload_link,   //this looks like vimeo.api.tus... something like tha
              retryDelays: [0, 1000, 3000, 5000],
              metadata: {
                  filename: file.name,
                  filetype: file.type
              },
              onError: function(error) {
                  console.log("Failed because: " + error)
              },
              onProgress: function(bytesUploaded, bytesTotal) {
                  const percentage = (bytesUploaded / bytesTotal * 100).toFixed(2);
                  progressBar.style.width = percentage + "%";
                  console.log(bytesUploaded, bytesTotal, percentage + "%");
              },
              onSuccess: function() {
                  console.log("Download %s from %s", upload.file.name, upload.url)

                  const anchor = document.createElement("a");
                  anchor.textContent = "Download " + upload.file.name + " (" + upload.file.size + " bytes)";
                  anchor.href = upload.url;
                  anchor.className = "btn btn-success";
                  uploadList.appendChild(anchor);

                  reset();
              }
          })
          // Start the upload
          upload.start()
          uploadIsRunning = true;
      } else {
          console.log("This is a developer error: " + e)
          console.log(e.target.status)
      }
  }.bind(this)
  xhr.send(JSON.stringify({
      upload:{
          approach: 'tus',
          size: file.size
      }
  }));
}


input.addEventListener("change", async function(e) {

  // Get the selected file from the input element
  file = e.target.files[0]
  // console.log(file)
  //const url = 'https://api.vimeo.com/users/iviggo/videos'
  
  // const request = new Request(url);
  // // let headers = new Headers();
  // // headers.append('Content-Type', 'application/json');
  // // headers.append('Accept', 'application/vnd.vimeo.*+json;version=3.4');
  // // headers.append('Authorization', 'Bearer b09934b8caddfdbceb5cc6261052ccc1');
  // // headers.append('Origin','*');
  // // headers.append('cache','no-cache');
  // // headers.append('credentials','same-origin');
  // // headers.append('redirect','follow');
  // // headers.append('referrer','no-referrer');
  
  // //headers.append('Access-Control-Expose-Headers','Content-Length,API-Key');
  
  // const response = await fetch(request, {
  //   method: 'POST',
  //   mode: 'cors',
  //   //credentials: 'include',
  //   //headers: headers,
  //   headers: {
  //     'Authorization': 'Bearer b09934b8caddfdbceb5cc6261052ccc1',
  //     'Content-Type': 'application/json',
  //     'Accept': 'application/vnd.vimeo.*+json;version=3.4',
  //     //'Access-Control-Allow-Origin': '*',
  //   },
  // });

  // if (response.ok) { // if HTTP-status is 200-299
  //   // get the response body (the method explained below)
  //   let json = await response.json();
  //   //let response = JSON.parse(e.target.responseText)
  //   console.log(json.upload.upload_link)
  //   console.log(response)
  //   console.log(json)
    
  //   let upload = new tus.Upload(file, {
  //       //endpoint: response.upload.upload_link,   //this looks like vimeo.api.tus... something like that
  //       uploadUrl: json.upload.upload_link,   //this looks like vimeo.api.tus... something like tha
  //       retryDelays: [0, 1000, 3000, 5000],
  //       metadata: {
  //           filename: file.name,
  //           filetype: file.type
  //       },
  //       onError: function(error) {
  //           console.log("Failed because: " + error)
  //       },
  //       onProgress: function(bytesUploaded, bytesTotal) {
  //           let percentage = (bytesUploaded / bytesTotal * 100).toFixed(2);
  //           progressBar.style.width = percentage + "%";
  //           console.log(bytesUploaded, bytesTotal, percentage + "%");
  //       },
  //       onSuccess: function() {
  //           console.log("Download %s from %s", upload.file.name, upload.url)

  //           let anchor = document.createElement("a");
  //           anchor.textContent = "Download " + upload.file.name + " (" + upload.file.size + " bytes)";
  //           anchor.href = upload.url;
  //           anchor.className = "btn btn-success";
  //           uploadList.appendChild(anchor);

  //           reset();
  //       }
  //   })
  //   // Start the upload
  //   upload.start()
  //   uploadIsRunning = true;

  // } else {
  //   alert("HTTP-Error: " + response.status);
  // }

})


function reset() {
  input.value = "";
  toggleBtn.textContent = "start upload";
  upload = null;
  uploadIsRunning = false;
}
