<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class QuickpaySubscriptions extends Model
{
    protected $table = 'quickpay_subscriptions';

    protected $fillable = [
        'subscription_id','operations', 'order_id', 'metadata', 'link', 'agreement_id', 'amount', 'payment_methods', 'accepted', 'user_package', 'state', 'created_user_id', 'vat', 'priceForCommission'
    ];



    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }

    public function package()
    {
        return $this->belongsTo('App\UserPackage','user_package');
    }


    public function quickpayRecurring() {
        return $this->hasMany('App\QuickpayRecurring','subscription_id','subscription_id');
    }

    public function quickpayPayments() {
        return $this->hasMany('App\QuickpayPayments','subscription_id','subscription_id');
    }

    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }
}


