<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Question extends Model
{
    protected $table = 'questions';

    protected $fillable = [
        'title', 'description', 'category_id', 'created_user_id', 'updated_user_id'
    ];

    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }

    public function Category()
    {
        return $this->belongsTo('App\Category', 'category_id');
    }

    public function Replies()
    {
        return $this->hasMany('App\QuestionReplies', 'question_id');
    }

    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }
}


