<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use App\User;
use App\CoachProfileInfo;
use Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Auth\Events\Registered;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Support\Facades\Mail;
use App\Mail\CoachSignup;
use Illuminate\Support\Facades\File;
use App\Countries;
use Illuminate\Support\Str;
//use App\Mail\SignupPasswordCreate;
use Illuminate\Support\Facades\Storage;
//use Session;
use App\Traits\UploadTrait;

use Spatie\Image\Image;
use Spatie\Image\Manipulations;
use Vimeo\Laravel\Facades\Vimeo;

use Illuminate\Contracts\Auth\MustVerifyEmail;


class SignupController extends Controller
{

    protected $user_id;
    protected $redirectTo = '/thanks';
    use HasRoles;
    use UploadTrait;

    public function __construct()
    {
        $this->middleware(['guest']);
    }


    protected function validator(array $data)
    {
        $validator = Validator::make($data, [
            'user' => 'required|array',
            'user.first_name' => 'required|min:2|max:40',
            'user.last_name' => 'required|min:2|max:80',
            'user.email' => 'required|email|unique:users,email',
            'user.password' => 'required|min:8|max:30|confirmed|secure_password',

            'general' => 'sometimes|array',/*
            'general.referral_invite_code' => 'required|ref_coach_invite_code|regex:/^[a-zA-Z0-9]+$/',*/
            'general.country' => 'required|alpha_spaces',
        /*    'general.invite_code' => 'required|unique:coach_profile,invite_code|regex:/^[a-zA-Z0-9]+$/',*/
            'general.introduction' => 'required|',
            'general.expertise' => 'required',
            'general.website' => ['required', 'regex:/^(http:\/\/www\.|https:\/\/www\.|http:\/\/|https:\/\/)?[^\.].*\.[a-z]{2,}?(\/.*)?$/'],
            'terms' => 'required|accepted',
            'privacy' => 'required|accepted',
            'photo' => 'file|mimes:jpeg,png,jpg|max:2048|dimensions:min_width=500,min_height=350',
            'g-recaptcha-response' => 'required|recaptcha',
        ], [
            'photo' => 'Profile Image should be jpg or png and size must not exceeds 2mb',
            'photo.max' => 'Profile Image size must not exceeds 2mb.',
       /*     'general.referral_invite_code.required' => 'The Referral Invitation Code field is required.',
            'general.referral_invite_code.ref_coach_invite_code' => 'The Referral Invitation Code not found. Please enter correct referral invite code.',
            'general.referral_invite_code.regex' => 'The Referral Invitation Code field must have valid characters and without spaces.',
            'general.invite_code.required' => 'The Invitation Code field is required.',
            'general.invite_code.unique' => 'The Invitation Code is already in use. Please enter unique invite code.',*/
            'general.introduction' => 'The expertise field is required and must have valid characters.',
            'general.expertise' => 'The Expertise field is required and must have valid characters.',
        ],['user.first_name' => 'First Name',
            'user.last_name' => 'Last name',
            'user.email' => 'Email',
            'user.password' => 'Password',

            'general.referral_invite_code' => 'Referral Invite Code',
            'general.invite_code' => 'Invite Code',
            'general.country' => 'Country',
            'general.introduction'=> 'Introduction',
            'general.expertise'=>'Expertise',
            'general.website' => 'Website',
            'photo' => 'Profile Picture',
            'g-recaptcha-response' => 'Captcha',
            'g-recaptcha-response.recaptcha' => 'Captcha verification failed',
            'g-recaptcha-response.required' => 'Please complete the captcha',

        ]);

        return $validator;
    }

    protected function uservalidator(array $data)
    {
        $validator = Validator::make($data, [
            'user' => 'required|array',
            'user.first_name' => 'required|min:2|max:40',
            'user.last_name' => 'required|min:2|max:80',
            'user.email' => 'required|email|unique:users,email',
            'user.password' => 'required|min:8|max:30|confirmed|secure_password',

            'general' => 'sometimes|array',
            /*

            'general.referral_invite_code' => 'nullable|ref_invite_code|regex:/^[a-zA-Z0-9]+$/',
            'general.invite_code' => 'nullable|unique:coach_profile,invite_code|regex:/^[a-zA-Z0-9]+$/',*/

        ], [

            /*'general.referral_invite_code.ref_invite_code' => 'The Referral Invitation Code not found. Please enter correct invite code.',
            'general.referral_invite_code.regex' => 'The Referral Invitation Code field must have valid characters and without spaces.',
            'general.invite_code.unique' => 'The Invitation Code is already in use. Please enter unique invite code.',*/
        ]);

        return $validator;
    }

    public function create(Request $request)
    {
        $countries = Countries::pluck('country_name','country_code')->toArray();;


        return view('pages.signup', ['countries' => $countries]);
    }




    public function user(Request $request)
    {
        $countries = Countries::pluck('country_name','country_code')->toArray();;


        return view('pages.user_signup', ['countries' => $countries]);
    }


    public function submit(Request $request)
    {

        $errors = $this->validator($request->all())->validate();
        $this->submit = $request->input('submit');

        $user = $request->user;
        $general = $request->general;


        //$general['coach_url'] = strtolower($user['first_name']).'-'.strtolower($user['last_name']);

        $newuser = User::create([
            'first_name' => $user['first_name'],
            'last_name' => $user['last_name'],
            'email' => $user['email'],
            'password' => bcrypt($user['password']),
            'new_password_token' => Str::random(40),
            'status' => 'inactive',
            'coach_id' =>''
        ]);

        $newuser->assignRole('coach');

        if (isset($newuser->id)) {
            $profile_photo = '';
            if ($request->has('photo')) {
                // Get image file
                $image = $request->file('photo');
                $image_name = time() . '.' . $image->getClientOriginalExtension();
                if (! File::exists(public_path('/uploads/thumbs/'))) {
                    File::makeDirectory(public_path('/uploads/thumbs/'));
                }

                if (! File::exists(public_path('/uploads/images/'))) {
                    File::makeDirectory(public_path('/uploads/images/'));
                }

                $destinationPath = public_path('/uploads/images/');

                $resize_image = Image::load($image->getRealPath());

                /*$resize_image->fit(Manipulations::FIT_FILL,270,270)->background('ffffff')->save($destinationPath . '270_' . $image_name);

                $resize_image->fit(Manipulations::FIT_FILL,470,510)->background('ffffff')->save($destinationPath . '470_' . $image_name);
                $resize_image->fit(Manipulations::FIT_FILL,115,115)->background('ffffff')->save($destinationPath . '115_' . $image_name);*/

                //$resize_image->save($destinationPath . '270_' . $image_name);

                //$resize_image->save($destinationPath . '470_' . $image_name);
                //$resize_image->save($destinationPath . '115_' . $image_name);

                $destinationPath = public_path('/uploads/images/');
                $resize_image->width(470)->save($destinationPath . $image_name);

                //$image->move($destinationPath, $image_name);

                $profile_photo = $image_name;

            }

            if(!empty($profile_photo)) {
                $this->default_condition = ["created_user_id" => $newuser->id, "updated_user_id" => $newuser->id, 'photo' => $profile_photo];
            } else {
                $this->default_condition = ["created_user_id" => $newuser->id, "updated_user_id" => $newuser->id];
            }


            $adminCode = User::role('superadmin')->pluck('id');
            $adminUser =  User::with(['coachInfo'])->find($adminCode)->first();
            $general['referral_invite_code'] = $adminUser['coachInfo']['invite_code'];
            $general['coach_url'] = strtolower($user['first_name']).'-'.strtolower($user['last_name']);
            $general['mobile'] = $general['phone'];
            CoachProfileInfo::updateOrCreate($this->default_condition, $general);
        }
        //return $newuser;
        Mail::to($newuser->email)->send(new CoachSignup($newuser));

        $adminEmails = User::role('superadmin')->pluck('email');
        Mail::to($adminEmails)->send(new CoachSignup($newuser,'yes'));



        if ($request->session()->exists('signup_token')) {
            $request->session()->forget('signup_token');
        } else {
            session(['signup_token' => $newuser->new_password_token]);
        }

        return redirect()->route('signup.thanks');
    }


    public function create_user(Request $request)
    {
        $this->validator($request->all())->validate();
        $this->submit = $request->input('submit');

        $user = $request->user;
        $general = $request->general;
        //return $user;
        $newuser = User::create([
            'first_name' => $user['first_name'],
            'last_name' => $user['last_name'],
            'email' => $user['email'],
            'password' => bcrypt($user['password']),
            'new_password_token' => Str::random(40),
            'status' => 'inactive',
            'coach_id' =>''
        ]);

        $newuser->assignRole('user');




        if (isset($newuser->id)) {
            $this->default_condition = ["created_user_id" => $newuser->id, "updated_user_id" => $newuser->id];
           /* if($general->invite_code=='') {
                $general->invite_code = NULL;
            }*/
            CoachProfileInfo::updateOrCreate($this->default_condition, $general);
        }


        //return $newuser;
        Mail::to($newuser->email)->send(new CoachSignup($newuser));

        if ($request->session()->exists('signup_token')) {
            $request->session()->forget('signup_token');
        } else {
            session(['signup_token' => $newuser->new_password_token]);
        }

        return redirect()->route('signup.thanks',['id'=>2]);
    }


}
