<?php

namespace App\Http\Controllers\Marketing;


use App\CoachProfileInfo;
use App\Commissions;
use App\Http\Controllers\Controller;
use App\Jobs\RenewNotification;
use App\Mail\ContactUs;
use App\Payouts;
use App\Presentation;
use App\UserPackage;
use Carbon\Carbon;
use App\SitePages;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Vimeo;
use Illuminate\Support\Facades\Mail;
use App\Mail\PaymentProcessed;

class AccountController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function __construct()
    {
       // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */



    public function index() {

        $user = Auth::user();
        $data['payouts_sum'] = Payouts::where('created_user_id',$user->id)->whereIn('status',['waiting','approved'])->sum('amount');
        $data['payouts'] = Payouts::where('created_user_id',$user->id)->get();

        $data['commission'] = Commissions::where('partner_id',$user->id)->sum('commission') - $data['payouts_sum'];

        $data['profile'] = CoachProfileInfo::with('user')->where('created_user_id',$user->id)->first();
        $data['tree'] = CoachProfileInfo::where('created_user_id',$user->id)->first()->getAllChildren();

        $data['twoLevel'] = CoachProfileInfo::where('created_user_id',$user->id)->first()->getTwoLevels();
        $data['user'] = $user;

/*        echo '<pre>';print_r($data);
        exit;*/

        //return  $data['payouts'];
        //$data['tree'] = CoachProfileInfo::where('created_user_id',$user->id)->first()->getAllChildren();
        //return $data;
        return view('marketing/pages/account',$data);
    }



}
