<?php

namespace App\Http\Controllers;

use App\Coachcomments;
use App\CoachCompanyEmployee;
use App\CoachProfileInfo;
use App\Countries;
use App\Createcompany;
use App\Mail\CoachSignup;
use App\User;
use App\UserCompanies;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Spatie\Image\Image;
use Auth;
use DB;
use PDF;


class CreatecompanyController extends Controller
{

    public function create()
    {
        $this->user = Auth::user();
        if(isset($this->user->id)) {
            $countries = Countries::pluck('country_name','country_code')->toArray();
            return view('pages.coach_createcompany', ['countries' => $countries]);
        }else{
            return redirect()->route('home.front');
        }
    }

    public function edit($id,$action)
    {
        $this->user = Auth::user();
        if(isset($this->user->id)) {
            $countries = Countries::pluck('country_name','country_code')->toArray();
            $company = Createcompany::where('company_id', '=', $id)->get()->first();
            $message = DB::table('createcompanies')->select('message','date')->join('comments', 'createcompanies.company_id', '=', 'comments.company_id')->where('createcompanies.company_id', '=', $id)->orderby('cid', 'DESC')->get();
            return view('pages.coach_editcompany',['company'=>$company, 'countries' => $countries, 'message' => $message,'updateFormData' => $action]);
        }else{
            return redirect()->route('home.front');
        }
    }

    public function updatetrans($id)
    {
        $this->user = Auth::user();
        if(isset($this->user->id)) {
            $countries = Countries::pluck('country_name','country_code')->toArray();
            $company = Createcompany::where('company_id', '=', $id)->get()->first();
            $previousMembersCount = CoachCompanyEmployee::where('company_id', '=', $id)->get()->count('id');
            $message = DB::table('createcompanies')->select('message','date')->join('comments', 'createcompanies.company_id', '=', 'comments.company_id')->where('createcompanies.company_id', '=', $id)->orderby('cid', 'DESC')->get();
            return view('pages.coach_editcompany',['company'=>$company, 'countries' => $countries, 'message' => $message, 'previousMembersCount' => $previousMembersCount]);
        }else{
            return redirect()->route('home.front');
        }
    }

    public function delete($id) {
        if (!is_numeric($id) || $id == 0 || strpos($id, ".")) {
            return redirect(route('company.get'))->with('message','record not found');
        }

        $record = Createcompany::find($id);
        if(isset($record->company_id)) {
            $record->delete();
        } else {
            return redirect(route('company.get'))->with('error', 'Company not found!');
        }

        return redirect(route('company.get'))->with('success', 'Company deleted!');
    }


    protected function validator(array $data)
    {
        $validator = Validator::make($data, [
            'company.company_name' => 'required',
            'company.email' => 'required|email|unique:users,email',
            'company.no_of_employees' => 'numeric|min:10',
            'company.no_of_members' =>  isset($data['company']['old_members']) ? '' : 'integer|min:10',
            'company.monthly' => 'integer|min:5|max:20',
       ], [
            'company.no_of_employees.integer' => 'Please enter only integers for Potential No. of Employees field',
            'company.agreed_members.integer' =>  'Please enter only integers for Agreed Members field'
        ],
        [
            'company.monthly' => 'Monthly/Employee',
            'company.no_of_members' => 'Members',
            'company.no_of_employees' => 'Potential No. of Employees'
        ]

        );

        return $validator;
    }

    public function submit(Request $request)
    {
        $this->validator($request->all())->validate();
        $this->user = Auth::user();
        $data = $request->company;

            if($request->input('company_id')) {
                $company = Createcompany::where('company_id', $request->input('company_id'))->get(['company_id'])->first();
            }
            else{
                $company = new Createcompany();
            }

            $company->company_name = $data['company_name'];
            $company->company_email = $data['company_email'];
            $company->company_website = $data['company_website'];
            $company->no_of_employees = $data['no_of_employees'];
            $company->phone_number = $data['mobile'];
            $company->address_line_1 = $data['address'];
            $company->address_line_2 = $data['address_line_2'];
            $company->country = $data['country'];
            $company->cvr = $data['cvr'];
            $company->postal_code = $data['zip_code'];
            $company->owner_first_name = $data['first_name'];
            $company->owner_last_name = $data['last_name'];
            $company->owner_phone_number = $data['mobile_number'];
            $company->owner_email = $data['email'];
            $company->agreed_members = $data['no_of_members'];
            $company->contract_start_date = $data['start_date'];
            $company->contract_end_date = $data['end_date'];
            $company->monthly_per_employee = $data['monthly'];
            $company->annually_per_employee = $data['annually'];
            $company->agreed_price = $data['agreed_price'];
            $company->coach_id = $this->user->id;
            $company->save();

        if($request->input('company_id')) {
            if($data['message'] != '') {
                $this->company = $company;
                $comments = new Coachcomments();
                $comments->company_id = $this->company->company_id;
                $comments->uid = $this->user->id;
                $comments->date = date('Y-m-d h:i:s');
                $username = $this->user->first_name . ' ' . $this->user->last_name;
                $comments->message = $data['message'] . ' => ' . $data['no_of_members'] . ' new members' . ' added by ' . $username . ' for the agreed price of ' . $data['agreed_price'].'€';
                $comments->save();
            }
        }

        $companyId = $company->company_id;
        $data['company_id'] = $companyId;
        $data['user_id'] = $this->user->id;

        if(!$request->input('updateFormData')) {

            // Creating subscription and generating the subscription link
            $paymentController = new PaymentController();
            $paymentController->createCompanySubscription(['company' => $company, 'companyInfo' => $data]);

            // Generate invoice and send to the emails
            if ($request->session()->has('qp_link')) {
                $data['link'] = $request->session()->pull('qp_link');
            }


            $userDetails = User::with('coachInfo')->find($company->coach_id);
            $vatDetails = Countries::where('country_code',$company->country)->orderBy('id','desc')->first();
            $data['vat_rate'] = $vatDetails->vat_rate;
            $data['country_name'] = $vatDetails->country_name;

            // Creating PDF Invoice and sending in the mail
            $pdf = PDF::loadView('pages.generate_pdf', $data);

            Mail::send('pages.generate_pdf_admin', $data, function ($message) use ($data, $pdf) {
                $adminEmails = User::role('superadmin')->pluck('email');
                foreach ($adminEmails as $email) {
                    $message->to($email, $email)
                        ->subject('Adminfaktura - Firmaregistrering');
                }
            });
            Mail::send('pages.generate_pdf', $data, function ($message) use ($data, $pdf) {
                $message->to($data['company_email'], $data['company_email'])
                    ->subject('Faktura - Firmaregistrering');
            });
            Mail::send('pages.generate_pdf', $data, function ($message) use ($data, $pdf) {
                $message->to($data['email'], $data['email'])
                    ->subject('Faktura - Firmaregistrering');
            });
            Mail::send('pages.generate_pdf', $data, function ($message) use ($data, $pdf) {
                $message->to($this->user->email, $this->user->email)
                    ->subject('Faktura - Firmaregistrering');
            });
        }
        return redirect('/coach/retreiveCompanies')->with('message','Company details are added/updated accordingly. Please make the payment and proceed accordingly.');
    }

}




