<?php

namespace App\Http\Controllers\Bo;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Spatie\Permission\Traits\HasRoles;
use App\Package;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

use Auth;



class PackagesController extends Controller
{
    use HasRoles;

    public function __construct()
    {

        $this->middleware(['auth','mixed']);
    }

    protected function editvalidator(array $data,$id)
    {
        return Validator::make($data, [
            'title' => 'required|max:255',
            'description' => 'required',
            'button_text' =>'required',
            'invoice_period' => 'required',
            'renew_button_text' => 'required',
        ]);
    }



    public function index()
    {
        $this->user = Auth::user();
        $packages = Package::orderby('id', 'ASC')->where('created_user_id', $this->user->id)->get();
        return view('bo.packages',['packages'=>$packages]);
    }

    public function create(Request $request)
    {
        $this->user = Auth::user();
        $intervals = ['1'=>'1 Month','2'=>'2 Months','3'=>'3 Months','12'=>'12 Months'];
        return view('bo.add_package' ,['intervals'=>$intervals]);
    }

    public function edit($id)
    {

        $intervals = ['1'=>'1 Month','2'=>'2 Months','3'=>'3 Months','12'=>'12 Months'];

        $page = Package::where('id', '=', $id)->get()->first();

        return view('bo.edit_package',['package'=>$page,'intervals'=>$intervals]);
    }

    public function delete($id){
        $this->user = Auth::user();
        $packages = Package::orderby('id', 'ASC')->where('created_user_id', $this->user->id)->get();
        $record = Package::find($id);
        if(isset($record->id)) {
            $record->delete();
        }
        return redirect(route('bo.packages',['packages'=>$packages]))->with('message', 'Package deleted!');
    }

    public function submit(Request $request)
    {

        $this->user = Auth::user();
        $page = Package::where('id', $request->input('id'))->get(['id'])->first();

        if($page) {
            $this->editvalidator($request->all(),$request->input('id'))->validate();

            $page->title = $request->input('title');
            $page->description = $request->input('description');
            $page->button_text = $request->input('button_text');
            $page->invoice_period = $request->input('invoice_period');
            $page->price = $request->input('price');
            $page->invoice_interval = 'month';
            $page->renew_button_text = $request->input('renew_button_text');
            $page->created_user_id = $this->user->id;
            $page->updated_user_id = $this->user->id;
            $page->save();
        }else{
            $package = new Package();
            $package->title = $request->input('title');
            $package->description = $request->input('description');
            $package->button_text = $request->input('button_text');
            $package->invoice_period = $request->input('invoice_period');
            $package->price = $request->input('price');
            $package->invoice_interval = 'month';
            $package->renew_button_text = $request->input('renew_button_text');
            $package->created_user_id = $this->user->id;
            $package->updated_user_id = $this->user->id;
            $package->save();
        }

        return redirect(route('bo.packages'));
    }

}
