<?php

namespace App\Http\Controllers\Auth;

use App\CoachCompanyEmployee;
use App\UserCompanies;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Spatie\Permission\Traits\HasRoles;
use App\User;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;
    use HasRoles;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    //protected $redirectTo = '/dashboard';

    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function authenticated($request , $user)
    {
        if($user->hasRole('superadmin'))
        {
            //return 'superadmin';
            return redirect()->route('bo.dashboard') ;
        }
        else if($user->hasRole('coach'))
        {
            return redirect()->route('coach.dashboard') ;

        }else if($user->hasRole('user'))
        {
            return redirect()->route('videos') ;

        }else if($user->hasRole('companyuser'))
        {
            $userId = $user->id;
            $employeeDet = CoachCompanyEmployee::orderBy('id', 'desc')->where('employee_id',$userId)->first();
            $userCompany= UserCompanies::orderBy('id', 'desc')->where(['status'=>'active'])->where('company_id', $employeeDet->company_id)->first();
            $contractEndDate = date('Y-m-d',strtotime($userCompany->ends_at));
            $today = date('Y-m-d');

            if(strtotime($contractEndDate) <= strtotime($today)){
                $user->status = 'inactive';
                $user->save();
                $this->logout($request);
                return redirect()
                    ->back()
                    ->withInput($request->only($this->username(), 'remember'))
                    ->withErrors(['active' => 'Sorry, Contract Expired! You cannot login to iviggo']);
            }else{
                $user->status = 'active';
                $user->save();
            }
        }

    }

    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    protected function validateLogin(Request $request)
    {
        $this->validate($request, [
            $this->username() => 'required|email',
            'password' => 'required|string',
            'g-recaptcha-response' => 'required|recaptcha',
        ],[
            'g-recaptcha-response' => 'Captcha',
            'g-recaptcha-response.recaptcha' => 'Captcha verification failed',
            'g-recaptcha-response.required' => 'Please complete the captcha',
        ]);
    }

    protected function hasTooManyLoginAttempts(Request $request)
    {
        return $this->limiter()->tooManyAttempts(
            $this->throttleKey($request), 5, 30
        );
    }

    public function login(\Illuminate\Http\Request $request) {
        $this->validateLogin($request);

        // If the class is using the ThrottlesLogins trait, we can automatically throttle
        // the login attempts for this application. We'll key this by the username and
        // the IP address of the client making these requests into this application.
        if ($this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);
            return $this->sendLockoutResponse($request);
        }

        // This section is the only change
        if ($this->guard()->validate($this->credentials($request))) {
            $user = $this->guard()->getLastAttempted();
            if($user->hasRole('companyuser')){
                $this->authenticated($request, $user);
            }
            // Make sure the user is active
            if ($user->status=='active' && $this->attemptLogin($request)) {

                $user->timezone = $request->timezone;
                $user->save();
                // Send the normal successful login response
                return $this->sendLoginResponse($request);
            } else {
                // Increment the failed login attempts and redirect back to the
                // login form with an error message.
                $this->incrementLoginAttempts($request);
                return redirect()
                    ->back()
                    ->withInput($request->only($this->username(), 'remember'))
                    ->withErrors(['active' => 'You must be active to login.']);
            }
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }


}
