<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Support\Facades\Password;
use Illuminate\Http\Request;
use App\Mail\InactiveAccountPassword;
use Illuminate\Support\Facades\Mail;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Support\Str;

use App\User;

class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    public function sendResetLinkEmail(Request $request)
    {
        $this->validateEmail($request);

        $user = User::where('email', $request->email)->first();

        if($user && $user->status == "inactive" && $user->hasRole('user')) {

            $user->new_password_token = Str::random(40);
            $user->save();

            Mail::to($user->email)->send(new InactiveAccountPassword($user));

            return redirect('login')->with('success', 'Your account was found inactive, please check your email to create password and activate your account');

        } else if($user && $user->status == "inactive" && $user->hasRole('coach')) {


            return redirect('login')->with('success', 'Your account is inactive, please wait for admin approval.');

        }
        else if(!$user) {
            $response = $this->broker()->sendResetLink(
                $request->only('email')
            );
            return $this->sendResetLinkFailedResponse($request, $response);
        }
        else {
            $response = $this->broker()->sendResetLink(
                $this->credentials($request)
            );

            return $response == Password::RESET_LINK_SENT
                ? $this->sendResetLinkResponse($request, $response)
                : $this->sendResetLinkFailedResponse($request, $response);
        }

    }

}
