<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Collection;


class User extends Authenticatable
{
    use Notifiable;
    use HasRoles;
    use SoftDeletes;


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'first_name', 'last_name', 'email', 'password','status','verification_code','coach_id', 'marketing_terms', 'marketing_terms_version', 'marketing_active', 'marketing_status', 'timezone', 'marketing_inactive'
    ];



    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    protected $dates = ['deleted_at'];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function coachInfo()
    {
        return $this->hasOne('App\CoachProfileInfo', 'created_user_id');
    }

    public function coachIntro()
    {
        return $this->hasMany('App\CoachIntro', 'created_user_id');
    }

    public function shazil(){
        return 'shazil is a guggu bacha';
    }

    public function video()
    {
        return $this->hasMany('App\Video', 'created_user_id');
    }

    public function videos()
    {
        return $this->hasMany('App\Video', 'created_user_id');
    }

    public function favorites()
    {
        return $this->hasMany('App\Favorite',  'created_user_id');

    }

    public function questions()
    {
        return $this->hasMany('App\Question',  'created_user_id');

    }

    public function coachSubscriptions()
    {
        return $this->hasMany('App\CoachSubscription', 'created_user_id');
    }

    public function userSubscriptions()
    {
        return $this->hasMany('App\UserPackage', 'created_user_id');
    }

    public function subscribers()
    {
        return $this->hasMany('App\CoachSubscription', 'coach_id');
    }

    public function isSuper()
    {
        return $this->hasRole('superadmin');
    }

    public function isCoach()
    {
        return $this->hasRole('coach');
    }

    public function isUser()
    {
        return $this->hasRole('user');
    }

    public function checkSubscription(User $user) {

        if(isset($user->id) && $user->hasRole('user')) {
            $subFilter = function ( $q){
                $q->where('status','active')->first();
            };
            $subscriptionDetails = User::with(['userSubscriptions'=>$subFilter])->find($user->id);

            // If trial expired...
            if($subscriptionDetails->userSubscriptions->count()==0) {
                return ['status'=>'error','route'=>'user.renew_package'];
            }
            if (is_null($subscriptionDetails->userSubscriptions[0]->subscription_id)) {
                return ['status'=>'error','route'=>'user.payments'];
            } else if ($subscriptionDetails->userSubscriptions[0]->state!='Approved') {
                return ['status'=>'error','route'=>'user.payments'];
            }
            $now = Carbon::now();
            if(Carbon::parse($subscriptionDetails->userSubscriptions[0]->ends_at)->diffInDays($now,false) > 0) {
                return ['status'=>'error','route'=>'user.payments'];
            }
            return ['status'=>'success'];
        }

    }

}
