<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;
use App\Video;


class VideoActive extends Mailable
{
    use Queueable, SerializesModels;

    public $first_name;
    public $last_name;
    public $video_title;
    public $type;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Video $video)
    {
        //

        $this->firstname = $video->user->first_name;
        $this->lastname = $video->user->last_name;
        $this->video_title = $video->video_title;
        $this->type = 'video';
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject(($this->type=='intro') ? 'Introduktions ':''.'Video godkendt')->markdown('emails.video_approved')->with([
            'first_name' => $this->firstname,
            'last_name' => $this->lastname,
            'video_title' => $this->video_title,
            'type' => $this->type,
        ]);
    }
}
