<?php

namespace App\Http\Controllers\Member;

use App\UserPackage;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Auth;

class AjaxController extends Controller
{
    protected $user;

    public function __construct(Request $request)
    {
        $this->middleware(['ajax']);
    }


    public function recurring(Request $request)
    {
        $this->validate($request, [
            'id' => 'required|integer'
        ]);
        $id = $request->input("id");
        $this->user = Auth::user();
        $code = 200;
        $response = [];

        if (!is_numeric($id) || $id == 0 || strpos($id, ".")) {
            return response()->json(["message" => "Bad request"], 422);
        }

        $rec = UserPackage::find($id);
        if($rec->package_id<=3) {
            if ($rec->recurring == 'active') {
                $rec->recurring = 'inactive';
            } else {
                $rec->recurring = 'active';
            }
            $rec->save();
            $response["message"] = "Success.";
        } else {
            return response()->json(["message" => "Bad request"], 422);
        }



        return response()->json($response, $code);
    }


}
