<?php

namespace App\Http\Controllers\Member;

use App\Mail\CoachSignup;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use App\Countries;
use App\UserPackage;
use App\User;
use App\CoachProfileInfo;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Spatie\Permission\Traits\HasRoles;
use App\Traits\UploadTrait;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\PasswordUpdate;
use Spatie\Image\Image;
use Spatie\Image\Manipulations;
use Vimeo\Laravel\Facades\Vimeo;



class AccountController extends Controller
{

    protected $user;
    use UploadTrait;
    use HasRoles;

    public function __construct()
    {

    }

    public function employeerequest(Request $request,$city=false){
        $this->user = Auth::user();
        $data["user"] = User::with(['coachInfo'])->where('id', $this->user->id)->get(['id', 'first_name','last_name', 'email'])->first();
        //return $data;
        $data['countries'] = Countries::pluck('country_name','country_code')->toArray();


        return view('member.editprofile', $data);
    }


    public function edit(Request $request,$city=false)
    {
        $this->user = Auth::user();
        $data["user"] = User::with(['coachInfo'])->where('id', $this->user->id)->get(['id', 'first_name','last_name', 'email'])->first();
        //return $data;
        $data['countries'] = Countries::pluck('country_name','country_code')->toArray();


        return view('member.editprofile', $data);
    }


    public function update(Request $request)

    {


        $user = Auth::user();

        $userInfo = User::with(['coachInfo'])->where('id', $user->id)->get()->first();

        $this->validate($request,[

            'user_first_name' => 'required|min:2|max:40',
            'user_last_name' => 'required|min:2|max:80',

        ]);


        $user->first_name = $request->input('user_first_name');

        $user->last_name = $request->input('user_last_name');






        $passwordMessage = false;
        if($request->input('user_old_password') && !empty($request->input('user_old_password'))){

            if (!(Hash::check($request->input('user_old_password'), Auth::user()->password))) {
                // The passwords matches
                return redirect()->back()->with("error","Your current password does not matches with the password you provided. Please try again.");
            }

            if(strcmp($request->input('user_new_password'), $request->input('user_old_password')) == 0){
                //Current password and new password are same
                return redirect()->back()->with("error","New Password cannot be same as your current password. Please choose a different password.");
            }

            $this->validate($request,[

                'user_new_password' => 'required|min:8|max:30|confirmed|secure_password',

            ]);



            $user->password = bcrypt($request->input('user_new_password'));

            $passwordMessage = true;



        }

        //$user->save();


        if($request->input('general_country')!=$userInfo->coachInfo->country) {
            $this->validate($request,[
                'general_country' =>  'required|alpha_spaces',
            ]);
            $vatInfo = Countries::pluck('vat_rate','country_code');
            if($vatInfo[$userInfo->coachInfo->country]!=$vatInfo[$request->input('general_country')]) {
                $userPackage = UserPackage::where(['status'=>'active','created_user_id'=>$user->id])->orderBy('id','desc')->first();
                if(isset($userPackage->id)) {
                    $userPackage->recurring = 'inactive';
                    $userPackage->save();
                }
            }
            $generalInfo['country'] = $request->input('general_country');
        }


        if($request->input('phone')!=$userInfo->coachInfo->mobile) {
            if($userInfo->marketing_terms=='yes' && $userInfo->marketing_status=='active') {
                $this->validate($request,[
                    'mobile' =>  'required',
                ]);
            } else {
                $this->validate($request,[
                    'mobile' =>  'nullable',
                ]);
            }

            $generalInfo['mobile'] = $request->input('phone');
        }

        /*

        if($request->input('general_introduction')!=$userInfo->coachInfo->introduction) {
            $this->validate($request,[
                'general_introduction' =>  'required|regex:/^[a-zA-Z0-9\s\-\_\,\#\/\.]+$/',
            ]);
            $generalInfo['introduction'] = $request->input('general_introduction');
        }

        if($request->input('general_expertise')!=$userInfo->coachInfo->expertise) {
            $this->validate($request,[
                'general_expertise' =>  'required|regex:/^[a-zA-Z0-9\s\-\_\,\#\/\.]+$/',
            ]);
            $generalInfo['expertise'] = $request->input('general_expertise');
        }

        if($request->input('website')!=$userInfo->coachInfo->website) {
            $this->validate($request,[
                'website' =>  'nullable|regex:/^[a-zA-Z0-9\s\-\_\,\#\/\.]+$/',
            ]);
            $generalInfo['website'] = $request->input('website');
        }

        if($request->input('company')!=$userInfo->coachInfo->company) {

            $this->validate($request,[
                'company' =>  'nullable|regex:/^[a-zA-Z0-9\s\-\_\,\#\/\.]+$/',
            ]);
            $generalInfo['company'] = $request->input('company');
        }*/

        if(isset($generalInfo)) {
            $this->default_condition = ["created_user_id" => $user->id, "updated_user_id" => $user->id];

            \App\CoachProfileInfo::updateOrCreate($this->default_condition, $generalInfo);
        }




        $user->save();
        if($passwordMessage) {
            Mail::to($user->email)->send(new PasswordUpdate($user));
        }
        return redirect('/profile/edit')->with('status', 'Profil opdateret!');


    }
}
