<?php

namespace App\Http\Controllers\Marketing;

use App\CoachProfileInfo;
use App\SitePages;
use Carbon\Carbon;
use http\Env\Response;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Arr;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Support\Facades\Auth;
use App\User;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;
    use HasRoles;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    //protected $redirectTo = '/dashboard';

    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function authenticated($request , $user)
    {
        if($user->hasAnyRole(['coach','superadmin','user']))
        {
            //return 'superadmin';
            return redirect()->route('marketing.dashboard') ;


        }

    }

    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function loginForm()
    {
        $data['content'] = SitePages::find(6);
        return view('marketing.login',$data);
    }

    protected function validateLogin(Request $request)
    {
        $this->validate($request, [
            $this->username() => 'required|email',
            'password' => 'required|string'
        ]);
    }

    protected function hasTooManyLoginAttempts(Request $request)
    {
        $this->validateLogin($request);
        return $this->limiter()->tooManyAttempts(
            $this->throttleKey($request), 5, 30
        );
    }


    public function postLogin(Request $request)
    {
        $auth = false;
        $credentials = $request->only('email', 'password');

        $email	       = $request->email;
        $password      = $request->password;

        if (Auth::validate(['email'=>$email,'password'=>$password])){


            $user = User::with('coachInfo')->where(['email'=>$email])->first();
            $authRoles = $user->getRoleNames()->toArray();
            if(in_array('companyuser', $authRoles)){
                return response()->json("Sorry, You cannot login to marketing site", 422,['Sorry, You cannot login to marketing site.']);
            }

            if($user->status == 'disable'){
                return response()->json("You must be active to login.", 422,['You must be active to login.']);
            }

            if (isset($user->id)) {
                // Send the normal successful login response
                if($user->marketing_inactive!=null && $user->marketing_status=='inactive') {
                    return response()->json("Your Account is disabled by Admin.", 422,['Your Account is disabled by Admin.']);
                } elseif($user->status=='inactive') {
                    return response()->json("Your Account is Inactive.",422, ["Your Account is Inactive."]);
                } else {
                    if($user->hasRole('user')) {
                        $checkSub = new User();
                        $checkSubStatus = $checkSub->checkSubscription($user);

                        if($checkSubStatus['status']=='error') {
                            return response()->json("You may need to renew your subscription package.", 422,['You may need to renew your subscription package.']);
                        }
                    }
                    $data['popup'] = true;
                    $continueLogin = false;
                    if(!empty($user->coachInfo->mobile)) {
                        $data['popup'] = false;
                        $continueLogin = true;
                    }


                    if($user->marketing_status=='active') {
                        $continueLogin = true;
                        Auth::attempt(['email'=>$email,'password'=>$password,'marketing_status'=>'active']);
                    } else {
                        $data['popup'] = true;
                        $continueLogin = false;
                        //$request->session()->flush();
                    }

                    $data['csrf'] = csrf_token();
                    $data['phone'] = $user->coachInfo->mobile;
                    $data['continue'] = $continueLogin;
                    $data['redirect'] = route('mkt.page',['slug'=>'account']);
                    return response()->json($data);
                }
            } else {
                return response()->json("User not found.", 422,['User not found.']);
            }


        } else {
            return response()->json("Please check your email or password and try again.", 422,['Please check your email or password and try again.']);

        }


    }

    public function login(Request $request) {
       //return $request;
        $this->validateLogin($request);
        // If the class is using the ThrottlesLogins trait, we can automatically throttle
        // the login attempts for this application. We'll key this by the username and
        // the IP address of the client making these requests into this application.
        if ($this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);
            return $this->sendLockoutResponse($request);
        }

        // This section is the only change
        if ($this->guard()->validate($this->credentials($request))) {
            $user = $this->guard()->getLastAttempted();

            // Make sure the user is active
            if ($user->status=='active' && $this->attemptLogin($request)) {
                $userInfo = CoachProfileInfo::where('created_user_id',$user->id)->first();
                $userInfo->mobile = $request->phone;
                $userInfo->save();

                $userBasic = User::find($user->id);
                $userBasic->marketing_terms = 'yes';
                $userBasic->marketing_status = 'active';
    /*            $userBasic->marketing_active = Carbon::now()->toDateTimeString();*/
                $userBasic->save();

                $adminUsers = User::role('superadmin')->with('coachInfo')->get();
                $adminUsersCode = Arr::pluck($adminUsers,'coachInfo.invite_code');


                $isAreaManager = CoachProfileInfo::whereIn('referral_invite_code',$adminUsersCode)->where('created_user_id',$user->id)->count();
                if($isAreaManager>0) {
                    $user->assignRole('is_am');
                } else {
                    // $isVip = CoachProfileInfo::where(['invite_code'=>$userInfo->referral_invite_code])->count();
                    // $isVip = CoachProfileInfo::whereIn('referral_invite_code',$adminUsersCode)->where(['invite_code'=>$userInfo->referral_invite_code])->count();

                    $refferalUser = CoachProfileInfo::where('invite_code',$userInfo->referral_invite_code)->with('user')->first();
                    $refferalAreaManager = CoachProfileInfo::whereIn('referral_invite_code',$adminUsersCode)->where('created_user_id',$refferalUser->user->id)->count();


                    if($refferalAreaManager > 0) {
                        $user->assignRole('is_vip');
                    } else {
                        $user->assignRole('is_mp');
                    }
                }


                    //referral_invite_code
                // Send the normal successful login response
                return $this->sendLoginResponse($request);
            } else {
                // Increment the failed login attempts and redirect back to the
                // login form with an error message.
                $this->incrementLoginAttempts($request);
                return redirect()
                    ->back()
                    ->withInput($request->only($this->username(), 'remember'))
                    ->withErrors(['active' => 'You must be active to login.']);
            }
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }
}
