<?php

namespace App\Http\Controllers\Common;

use App\CoachIntro;
use App\Commissions;
use App\Favorite;
use App\Payouts;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\User;
use Auth;
use DB;
use Carbon\Carbon;
use App\Tag;
use QuickPay\QuickPay;
use Vimeo;
use App\CoachSubscription;
use App\Package;

class AjaxController extends Controller
{
    protected $user;

    public function __construct(Request $request)
    {
        $this->middleware(['ajax']);
    }

    public function tags(){
        $tags = DB::table('tags')->orderBy('title','asc')->pluck( 'title','id');
        return response()->json($tags);
    }


    public function introcheck(){
        $this->user = Auth::user();
        $code = 200;
        $response = [];

        if(isset($this->user->id)) {
            $rec = CoachIntro::where([
                'created_user_id' => $this->user->id
            ])->count();

            if($rec < 3) {
                $response["message"] = "Success";
                return response()->json($response, $code);
            } else {
                return response()->json("You have already added 3 introductory videos.", 422);
            }

        } else {
            return response()->json("Bad request", 422);
        }
    }

    public function vat($countryCode,$id,$packageVal){
        if(!empty($countryCode) && !empty($id)) {
            $packageInfo = Package::find($id);
            $rec = DB::table('countries')->where('country_code',$countryCode)->orderBy('id','desc')->first();
            if($rec->id) {
                $packagePrice = $packageVal;
                $percentTotal = ($packagePrice * $rec->vat_rate)/100;
                $totals = $packagePrice+$percentTotal;
                $html = '<table class="table table-striped mt-3"><tbody><tr><td width="60%">'.$packageInfo->title.'</td>';
                $html .= '<td width="40%">€<span id="monsub"> '.number_format($packagePrice, 2).'</span></td></tr><tr>';
                $html .= '<td>VAT ('.$rec->vat_rate.'%)</td><td>€ '.'<span id="vat_amount_val">'.$percentTotal.'</span></td></tr><tr class="info">';
                $html .= '<td><strong>Total</strong></td><td><strong>€<span id="monsubtotal"> '.number_format($totals, 2).'</span></strong></td></tr></tbody></table>';
                return response()->json(['percent_totals'=>$percentTotal,'html'=>$html]);
            }

        } else {
            return response()->json(["message" => "Bad request"], 422);
        }

    }

    public function refreshCaptcha()
    {
        return response()->json(['captcha'=> captcha_img()]);
    }


    public function subscription(Request $request){
        $this->validate($request,[
            'id' => 'required|integer',
            'type' => 'required|alpha',
        ]);
        $id = $request->input("id");
        $type = $request->input("type");
        $this->user = Auth::user();
        $code = 200;
        $response = [];

        if(!is_numeric($id) || $id == 0 || strpos($id, "."))
        {
            return response()->json(["message" => "Bad request"], 422);
        }

        if( !in_array($type, ['subscribe','unsubscribe']) )
        {
            return response()->json(["message" => "Bad request"], 422);
        }

        if($type=='subscribe') {
            $rec = CoachSubscription::updateOrCreate([
                'coach_id' => $id,
                'created_user_id' => $this->user->id,
                'updated_user_id' => $this->user->id,
            ]);

            $count = CoachSubscription::where([
                'coach_id' => $id
            ])->count();

            $response["nextAction"] = "unsubscribe";
            $response["nextActionTitle"] = "Stop Følg Coach";
            $response["message"] = "Coach successfully subscribed.";
            $response["count"] = $count;

        }

        if($type=='unsubscribe') {
            $rec = CoachSubscription::where([
                'coach_id' => $id,
                'created_user_id' => $this->user->id
            ])->get()->first();
            if(isset($rec->id)) {
                $rec->delete();
                $count = CoachSubscription::where([
                    'coach_id' => $id
                ])->count();
                $response["nextActionTitle"] = "Følg Coach";
                $response["nextAction"] = "subscribe";
                $response["message"] = "Coach successfully unsubscribed.";
                $response["count"] = $count;
            } else {
                return response()->json(["message" => "Bad request"], 422);
            }
        }
        return response()->json($response, $code);
    }

    public function favorite(Request $request){
        $this->validate($request,[
            'id' => 'required|integer',
            'type' => 'required|alpha',
        ]);
        $id = (int)$request->input("id");
        $type = $request->input("type");
        $this->user = Auth::user();
        $code = 200;
        $response = [];

        if(!is_numeric($id) || $id == 0 || strpos($id, "."))
        {
            return response()->json(["message" => "Bad ID request"], 422);
        }

        if( !in_array($type, ['favorite','unfavorite']) )
        {
            return response()->json(["message" => "Bad Action request"], 422);
        }

        if($type=='favorite') {
            $rec = Favorite::updateOrCreate([
                'video_id' => $id,
                'created_user_id' => $this->user->id,
                'updated_user_id' => $this->user->id,
            ]);

            $response["nextAction"] = "unfavorite";
            $response["message"] = "Video successfully added to favorites.";
            $response['html'] = '<span class="e-button-text"><i class="fa fa-heart " style="padding-right:3px;"></i> Remove from Favorite</span>';

        }

        if($type=='unfavorite') {
            $rec = Favorite::where([
                'video_id' => $id,
                'created_user_id' => $this->user->id
            ])->get()->first();
            if(isset($rec->id)) {
                $rec->delete();
                $response["nextAction"] = "favorite";
                $response["message"] = "Video successfully removed from favorites.";
                $response['html'] = '<span class="e-button-text"><i class="fa fa-heart " style="padding-right:3px;"></i> Add to Favorite</span>';
            } else {
                return response()->json(["message" => "Bad request"], 422);
            }
        }
        return response()->json($response, $code);
    }

    public function coaches(Request $request)
    {
        $this->validate($request,[
            'id' => 'required|integer',
            'type' => 'required|alpha',
        ]);

        $id = $request->input("id");
        $type = $request->input("type");
        $this->user = Auth::user();
        $code = 200;
        $response = [];

        if(!is_numeric($id) || $id == 0 || strpos($id, "."))
        {
            return response()->json(["message" => "Bad request"], 422);
        }

        if( !in_array($type, ["remove",'enable','disable']) )
        {
            return response()->json(["message" => "Bad request"], 422);
        }



        if($type=='enable')
        {

            $coach = User::where('id', '=', $id)->get(['id', 'first_name','last_name', 'email'])->first();
            $coach->status = 'active';
            $coach->save();

            Mail::to($coach->email)->send(new CoachActive($coach));

            $response["message"] = "Account is enabled.";
        }
        elseif($type=='disable')
        {


            $coach = User::where('id', '=', $id)->get(['id', 'first_name','last_name', 'email'])->first();
            $coach->status = 'inactive';
            $coach->save();

            Mail::to($coach->email)->send(new CoachActive($coach));

            $response["message"] = "Account is disabled.";
        }
        elseif($type=='remove')
        {

            $coach = User::where('id', '=', $id)->delete();

            $response["message"] = "Account is deleted.";
        }
        else
        {
            $response["message"] = "User not found";
            $code = 422;
        }

        return response()->json($response, $code);

    }

    public function payout(Request $request){
        $this->validate($request, [
            'id' => 'required|integer',
            'amount' => 'required|numeric'
        ]);
        $user = Auth::user();
        $code = 200;
        $response = [];

        $data['commission'] = Commissions::where('partner_id',$user->id)->sum('commission');
        $data['payouts_sum'] = Payouts::where('created_user_id',$user->id)->whereIn('status',['waiting','approved'])->sum('amount');
        $payoutAccountTotals = $data['commission'] - $data['payouts_sum'];

        $data['min'] =config('iviggo.payout_limit');


        if($request->amount <= $payoutAccountTotals &&  $request->amount >= $data['min']) {
            Log::info('Payout Req - 1st');
            $orderID = "ivpay" . $request->id . time();
            $client = new QuickPay(':' . env('QUICKPAY_PAYOUT'));
            $payoutReq = $client->request->post('/payouts', [
                'order_id' => $orderID,
                'currency' => 'dkk',
                'variables' => ['id' => $request->id , 'email' => $user->email, 'amount'=>$request->amount*100]
            ]);

            Log::info($payoutReq->httpStatus());
            if ($payoutReq->httpStatus() === 201) {
                Log::info('Payout Req - 2nd - Response Success From QP');
                $payoutReqObject = $payoutReq->asObject();
                $endpoint = sprintf("/payouts/%s/link", $payoutReqObject->id);

                Log::info('Payout Req - 3d - QP link Generation');
                $encryptedStr = Crypt::encryptString($user->id . '**' . $orderID . '**payout');


                //Issue a put request to create payment link
                $link = $client->request->put($endpoint, [
                    "amount" => $request->amount * 100,
                    "language" => 'da',
                    "continue_url" => route('payout.success', ['token' => $encryptedStr]),
                    "cancel_url" => route('payout.fail', ['token' => $encryptedStr]),
                    "callback_url" => route('payout.info')
                ]);

                if ($link->httpStatus() === 200) {

                    $newPayout = new Payouts();
                    $newPayout->amount = $request->amount;
                    $newPayout->status = 'waiting';
                    $newPayout->created_user_id = $request->id;
                    $newPayout->updated_user_id = $request->id;
                    $newPayout->updated_user_id = $request->id;
                    $newPayout->order_id = $orderID;
                    $newPayout->save();


                    Log::info('Payout Req - 4th - 200 from QP link Generation');
                    $subscriptionLink = $link->asObject()->url;

                    session(['qpay_link' => $subscriptionLink]);

                    $response["url"] = $subscriptionLink;
                    return response()->json($response, $code);
                } else {
                    return response()->json(["message" => "Bad request"], 422);
                }


            } else {
                return response()->json(["message" => "Bad request"], 422);
            }
        } elseif($request->amount < $data['min']) {
            return response()->json(["message" => "Minimum Payout amount should not be less than kr.".config('iviggo.payout_limit')], 422);
        }elseif($request->amount > $payoutAccountTotals) {
            return response()->json(["message" => "Payout amount should not be greater than your account balance. kr.".$payoutAccountTotals], 422);
        }



        return response()->json($response, $code);
    }



}
