<?php

namespace App\Http\Controllers\Bo;

use App\Staff;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

use Auth;
use Spatie\Image\Image;
use Spatie\Image\Manipulations;
use Vimeo\Laravel\Facades\Vimeo;


class StaffController extends Controller
{
    use HasRoles;

    public function __construct()
    {
        $this->middleware(['auth', 'isSuper']);

    }

    protected function editvalidator(array $data)
    {
        return Validator::make($data, [
            'id' => 'required|integer',
            'title' => 'required|max:255',
            'description' => 'required|max:500'
        ],[],[
            'title' => 'Name',
        ]);
    }

    protected function addvalidator(array $data)
    {
        return Validator::make($data, [
            'title' => 'required|max:255',
            'description' => 'required|max:500',
            'photo' => 'required',
        ],[],[
            'title' => 'Name',
            'photo' => 'Picture'
        ]);
    }

    public function index($id=false)
    {
        if($id && is_numeric($id)) {
            $data['record'] = Staff::find($id);
        }
        $data['staff'] = Staff::orderby('id', 'ASC')->get();
        return view('bo.staff',$data);
    }


    public function submit(Request $request)
    {

        $this->user = Auth::user();

        if(isset($request->id)) {
            $this->editvalidator($request->all())->validate();
        } else {
            $this->addvalidator($request->all())->validate();
        }


        $photo = '';
        if ($request->has('photo')) {

            $this->validate($request,[

                'photo' =>  'image|mimes:jpeg,png,jpg|max:2048',

            ],['photo.max'=>'The Picture may not be greater than 2MB.'],['photo'=>'Picture']);
            // Get image file
            $image = $request->file('photo');

            $image_name = time() . '.' . $image->getClientOriginalExtension();


            if (! File::exists(public_path('/uploads/images/'))) {
                File::makeDirectory(public_path('/uploads/images/'));
            }

            $destinationPath = public_path('/uploads/images/');

            $resize_image = Image::load($image->getRealPath());
            $resize_image->width(470)->save($destinationPath . $image_name);
            //$resize_image->save($destinationPath . '270_' . $image_name);
            $photo = $image_name;

        }

        if(isset($request->id)) {
            $successMsg = 'Record updated successfully.';
            $record = Staff::find($request->id);


        } else {
            $successMsg = 'Record added successfully.';
            $record = new Staff();

        }
        $record->title = $request->title;
        $record->description = $request->description;
        if(!empty($photo)) {
            $record->photo = $photo;
        }
        $record->save();



        return redirect(route('bo.staff'))->with('success',$successMsg);
    }

    public function delete($id) {
        if (!is_numeric($id) || $id == 0 || strpos($id, ".")) {
            return redirect(route('bo.staff'))->with('message','record not found');
        }


        $record = Staff::find($id);
        if(isset($record->id)) {
            $record->delete();
        } else {
            return redirect(route('bo.staff'))->with('error', 'Staff Profile not found!');
        }

        return redirect(route('bo.staff'))->with('success', 'Staff Profile deleted!');
    }
}
