<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use App\Mail\PasswordCreated;
use App\User;

class CreatePasswordController extends Controller
{
    public function __construct()
    {
        $this->middleware('guest');
    }

    public function index(Request $request, $token)
    {
        $user = User::where('new_password_token', $token)->first();

        if( $user )
        {
            if( round( ( time() - strtotime($user->updated_at) ) / 3600) > 2 )
            {
                $user->new_password_token = null;
                $user->new_password_attempts = null;
                $user->save();

                return redirect()->route('login');
            }
            else
            {
                return view('auth.passwords.create')->with(['token' => $token]);
            }
        }
        else
        {
            return redirect()->route('login');
        }

    }

    public function create(Request $request, $token)
    {
        $this->validate($request, [
            'password' => 'required|min:8|max:12|confirmed|secure_password',
        ]);

        $user = User::where('new_password_token', $token)->first();

        if($user)
        {
            $user->password = bcrypt($request->password);
            $user->new_password_token = null;
            $user->new_password_attempts = null;
            $user->status = 'active';
            $user->save();

            Mail::to($user->email)->send(new PasswordCreated($user));

            if ($request->session()->exists('signup_token'))
            {
                $request->session()->forget('signup_token');
            }

            return redirect('login')->with('success', 'Your password has been created. Please use your credentials to log in below.');

        }
        else
        {
            return redirect()->back()->with('error', 'Unable to create password, please try again');
        }

    }
}
