<?php

namespace App\Console\Commands;

use App\CoachIntro;
use App\Video;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\File;
use Vimeo\Laravel\Facades\Vimeo;
use Spatie\Image\Exceptions\InvalidManipulation;
use Spatie\Image\Image;
use Spatie\Image\Manipulations;
use Illuminate\Support\Facades\Log;
use App\Countries;


class updateVat extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    use SoftDeletes;
    protected $signature = 'vat:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update Vat Rates';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {

        $endpoint = 'https://api.vatsense.com/1.0/rates';
        $apikey = 'a370e7d7e07a4c411d0b8ac5b43e2b5c';
        $ch = curl_init();

// set curl options
        curl_setopt($ch, CURLOPT_URL, $endpoint);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($ch, CURLOPT_USERPWD, 'user:'.$apikey);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);

        $response = curl_exec($ch);

        Log::info($response);

        curl_close($ch);

        $jsonRates = json_decode($response);
        if(isset($jsonRates->data)) {

            foreach($jsonRates->data as $item) {
                $rec = Countries::firstWhere('country_code',$item->country_code);
                if(isset($rec->country_code) && isset($item->standard->rate)) {
                    $rec->vat_rate = $item->standard->rate;
                    $rec->save();
                }
            }
        }

    }
}
