<?php

namespace App\Console\Commands;

use App\Countries;
use App\Http\Controllers\PaymentController;
use App\Mail\ExpiredEmail;
use App\Mail\RenewEmail;
use App\User;
use App\UserPackage;
use App\UserPackagePrices;
use Illuminate\Console\Command;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Spatie\Permission\Traits\HasRoles;


class renewSubscription extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    use HasRoles;
    protected $signature = 'renew:subscription';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Renew Expired Subscriptions';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $userPackages = UserPackage::with(['user'=> function ($q) {
            $q->withTrashed();
        }, 'plan'])->where(['status' => 'active', 'cancels_at' => NULL, 'canceled_at' => NULL])->whereDate('ends_at', '<=', Carbon::now())->get();

        $now = Carbon::now();
        if ($userPackages->count() > 0) {
            foreach ($userPackages as $userPackage) {

                if (is_null($userPackage->user->deleted_at) && $userPackage->user->hasRole('user')) {

                    if (Carbon::parse($userPackage->ends_at)->diffInDays($now, false) >= 0) {
                        $opening = UserPackage::find($userPackage->id);
                        if($userPackage->recurring=='active') {


                            $newRec = $opening->replicate()->fill([
                                'state' => 'pending',
                                'status' => 'inactive',
                                'starts_at' => Carbon::now()->toDateTimeString(),
                                'ends_at' => Carbon::now()->add($userPackage->plan->invoice_period, $userPackage->plan->invoice_interval)->toDateTimeString(),
                            ]);
                            $newRec->save();


                            $userPackage = UserPackage::with(['user', 'plan'])->find($newRec->id);
                            $userDetail = UserPackagePrices::where('user_id', $userPackage->created_user_id)->first();

                            if(isset($userDetail->id)) {
                                $priceForCustomer = $userDetail->price_for_customer;
                                $userInformation = User::with('coachInfo')->find($userPackage->created_user_id);
                                $vatDetails = Countries::where('country_code', $userInformation->coachInfo->country)->orderBy('id', 'desc')->first();
                                $percentTotal = ($priceForCustomer * $vatDetails->vat_rate) / 100;
                                $totals = ($priceForCustomer + $percentTotal) * 100;
                            } else {
                                $totals = '';
                                $priceForCustomer = '';
                            }


                            $controller = new PaymentController();
                            $controller->createrecurring($userPackage,'',$totals,$priceForCustomer);
                        } else {
                            $opening->status = 'expired';
                            $opening->cancels_at = Carbon::now()->toDateTimeString();
                            $opening->canceled_at = Carbon::now()->toDateTimeString();
                            $opening->save();

                            $details = ['record' => $opening, 'days'=>3, 'url'=>route('user.payments'),'email'=>$opening->user->email];
                            Mail::to($opening->user->email)->send(new ExpiredEmail($details));


                        }
                    }
                }
            }
        }
    }


}
