<?php

    $collectionOfRoles = ['coach','superadmin'];
    $adminRoles = ['superadmin'];
    $coachOnly = ['coach'];
    $mixedUsers = ['coach','user'];
    $allroles = ['coach','user', 'superadmin'];


?>
<header id="header" class="sticky transparent-header ">
    <div class="topheader top_header_light ">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-4 content-center-mobile mb-1">
                    <div class="address-icon"><a href="tel:+45 42217569"><i class="fas fa-phone"></i>+45 42217569</a></div>
                    <div class="address-icon"><a href="mailto:support@iviggo.com"><i class="fas fa-envelope"></i>support@iviggo.com</a></div>
                </div>
                <?php if(Auth::check()): ?>

                    <div class="col-lg-8 col-md-8 content-center-mobile text-right">
                        <div class="custom-page-top">
                            <?php if(auth()->check() && auth()->user()->hasRole($coachOnly)): ?>
                            <a href="<?php echo e(route('company.get')); ?>" >Register a Company</a>
                            <?php endif; ?>
                            <?php if(auth()->check() && auth()->user()->hasRole($adminRoles)): ?>
                            <a href="<?php echo e(route('company.get')); ?>" >View Companies</a>
                            <?php endif; ?>
                            
                            
                            <?php if(auth()->check() && auth()->user()->hasAnyRole($collectionOfRoles)): ?>

                            <a href="<?php echo e(route('video.upload')); ?>"><i class="fas fa-plus-circle"></i>Upload Video</a>

                            <a href="<?php echo e(route('coach.dashboard')); ?>"><i class="fas fa-user-cog"></i>My Profile</a>
                            <?php endif; ?>
                            <?php if(auth()->check() && auth()->user()->hasRole('user')): ?>
                            <a href="<?php echo e(route('users.edit')); ?>"><i class="fas fa-user-cog"></i>My Profile</a>
                            <?php endif; ?>
                            <a href="javascript:void(0)" id="logout">
                                <i class="fas fa-user-circle "></i>Logout</a></div>
                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                            <?php echo e(csrf_field()); ?>

                        </form>


                    </div>


                <?php else: ?>
                    <div class="col-lg-8 col-md-8 content-center-mobile text-right">
                        <div class="custom-page-top">
                            
                            <a href="<?php echo e(route('join')); ?>"><i class="fas fa-plus-circle"></i><?php echo e(__('Join Now')); ?></a><a
                                href="<?php echo e(route('login')); ?>"><i
                                    class="fas fa-user-circle "></i><?php echo e(__('Login')); ?></a></div>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- #navigation start -->
    <nav class="navbar navbar-default navbar-expand-md navbar-light" id="navigation" data-offset-top="1">
        <!-- .container -->
        <div class="container">
            <!-- Logo and Menu -->
            <div class="navbar-header">
                <div class="navbar-brand"><a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('images/logo.svg')); ?>"
                                                                      alt="Logo"/></a></div>
                <!-- site logo -->
            </div>
            <!-- Menu Toogle -->
            <div class="burger-icon">
                <div class="bar1"></div>
                <div class="bar2"></div>
                <div class="bar3"></div>
            </div>
            
            <div class="collapse navbar-collapse " id="navbarCollapse">
                <ul class="nav navbar-nav ml-auto">
                    <!-- Menu Link -->
                    <?php if(Auth::check()): ?>
                        <?php if(auth()->check() && auth()->user()->hasRole('user')): ?>
                        <li>
                            <a href="<?php echo e(route('user.payments')); ?>" class="<?php echo e((Route::currentRouteName()== 'user.payments') ? 'active' : ''); ?>">My Subscription</a>

                        </li>
                        <?php endif; ?>
                        <?php if(auth()->check() && auth()->user()->hasRole('is_am')): ?>

                        <li class="subnav"><a href="#" >My Admin Panel</a>
                            <ul class="sub-menu">
                                <li><a href="<?php echo e(route('bo.videos')); ?>" class="nav-link ">Approve videos </a></li>
                                <li><a href="<?php echo e(route('bo.intros')); ?>" class="nav-link ">Approve introductory videos </a></li>
                                <?php if(auth()->check() && auth()->user()->hasRole('coach')): ?>
                                <li><a href="<?php echo e(route('bo.coaches')); ?>" class="nav-link ">Coach Applications </a></li>
                                <?php endif; ?>
                            </ul>
                        </li>

                        <?php endif; ?>

                        <?php if(auth()->check() && auth()->user()->hasRole('superadmin')): ?>
                        <li class="subnav">
                            <a href="#" class="<?php echo e((strpos(Route::currentRouteName(), 'bo') === false) ? '' : 'active'); ?>">My Admin Panel</a>
                            <ul class="sub-menu">
                                <li><a href="<?php echo e(route('bo.videos')); ?>" class="nav-link ">Approve videos (<?php echo e(getPendingVideosCount()); ?>)</a></li>
                                <li><a href="<?php echo e(route('bo.intros')); ?>" class="nav-link ">Approve introductory videos (<?php echo e(getPendingIntrosCount()); ?>)</a></li>
                                <li><a href="<?php echo e(route('bo.coaches')); ?>" class="nav-link ">Coach Applications (<?php echo e(getPendingCoachesCount()); ?>)</a></li>
                                <li><a href="<?php echo e(route('manage.members')); ?>" class="nav-link ">Manage members</a></li>
                                <li><a href="<?php echo e(route('bo.pages')); ?>" class="nav-link ">Manage Pages</a></li>
                                <li><a href="<?php echo e(route('bo.staff')); ?>" class="nav-link ">Manage Staff</a></li>
                                <li><a href="<?php echo e(route('bo.categories')); ?>" class="nav-link ">Manage Categories</a></li>
                                <li><a href="<?php echo e(route('bo.packages')); ?>" class="nav-link ">Manage Packages</a></li>
                                <li><a href="<?php echo e(route('bo.questions')); ?>" class="nav-link ">Manage Questions</a></li>
                                <li><a href="<?php echo e(route('bo.payouts')); ?>" class="nav-link ">iviggo internal payouts</a></li>
                                

                            </ul>
                        </li>
                        <?php endif; ?>


                    <?php endif; ?>
                    
                    <li class="subnav">
                        <a href="#"><?php echo e(__('Presentation')); ?></a>
                        <ul class="sub-menu">
                            <li><a href="<?php echo e(asset('documents/Iviggo_presentation Eng.pdf')); ?>" target="blank">iviggo presentation Eng</a></li>
                            <li><a href="<?php echo e(asset('documents/Iviggo_presentation Dan.pdf')); ?>" target="blank">iviggo presentation Dan</a></li>
                            <li><a href="<?php echo e(asset('documents/company-package Eng.pdf')); ?>" target="blank">Company Package Eng</a></li>
                            <li><a href="<?php echo e(asset('documents/company-package Dan.pdf')); ?>" target="blank">Company Package Dan</a></li>
                        </ul>
                    </li>
                    <li>
                        <a href="<?php echo e(route('videos')); ?>" class="<?php echo e((Route::currentRouteName()=='videos') ? 'active' : ''); ?>"><?php echo e(__('Video Library')); ?></a>

                    </li>

                    <li>
                        <a href="<?php echo e(route('coaches')); ?>" class="<?php echo e((Route::currentRouteName()=='coaches') ? 'active' : ''); ?>"><?php echo e(__('Coach Panel')); ?></a>

                    </li>
                    

                    <?php if(auth()->check() && auth()->user()->hasRole('companyuser')): ?>
                    <li>
                        <a href="<?php echo e(route('users.employee')); ?>"><i class="fas fa-user-cog"></i>My Profile</a>
                    </li>
                    <?php endif; ?>
                    <?php if(Auth::check()): ?>

                        <?php if(auth()->check() && auth()->user()->hasAnyRole($collectionOfRoles)): ?>
                        <li>
                            <a href="<?php echo e(route('q.questions')); ?>" class="<?php echo e((Route::currentRouteName()=='q.questions') ? 'active' : ''); ?>">Video Question Box</a>

                        </li>

                        <?php endif; ?>
                        <?php if(auth()->check() && auth()->user()->hasRole('user')): ?>
                        <li>
                            <a href="<?php echo e(route('questions')); ?>" class="<?php echo e((Route::currentRouteName()=='questions') ? 'active' : ''); ?>">Video Question Box</a>

                        </li>
                        <?php endif; ?>



                    <?php endif; ?>


                </ul>

            </div>
            <!-- Menu Toogle end -->
        </div>
        <!-- .container end -->
    </nav>
    <!-- #navigation end -->
</header>
<?php /**PATH /home/ivigoo/html/development/resources/views/partials/marketing/header.blade.php ENDPATH**/ ?>