@extends('layouts.marketing')
@section('content')
    <!-- Page Content start -->


    <div id="Statispages" class="wrap-bg">
        <div class="container">
            <h3>{{$page->title}}
            </h3>
            <div class="row">
                <div class="col-sm-12 buttons">
                    <a href="#" class="color-two btn-custom printAct"><i class="fa fa-print"></i> Print</a>
                    @if(!empty($page->presentation_image))
                    <a href="{{route('download',['file'=>$page->presentation_image])}}"   class="color-two btn-custom " target="_blank" >  Download Image</a>
                    @endif

                </div>

                <div class="col-sm-12 printable" >
                    <br><br>
                    {!!$page->content !!}
                </div>

            </div>

        </div>
    </div>

    <!-- Page Content end -->
@endsection
@push('styles')
    <style>
        @media print {
            body * {
                visibility: hidden !important;
            }
            .hideOnPrint {
                display: none !important;
            }
            #mainPrintArea, #mainPrintArea * {
                visibility: visible !important;
            }
            #mainPrintArea {
                font-size: 0.8em !important;
            }
            #mainPrintArea h1 {
                font-size: 1.6em !important;
            }
            #section-to-print {
                position: absolute !important;
                left: 0 !important;
                top: 0 !important;
            }
        }

        @media print {

            body * {

                visibility: hidden !important;

            }

            #cardFormPrint {

                display: none !important;

            }

            #printArea,
            #printArea * {

                visibility: visible !important;

            }

        }
    </style>
@endpush

@push('scripts')
    {!! Html::script('js/printThis.js') !!}
    <script>
        $(document).ready(function () {
            $('.printAct').on('click',function(e){
                e.preventDefault();
                $(".printable").printThis({
                    header: "<h3>{{$page->title}}</h3>",
                    printContainer: true,
                });
            });

        });
    </script>
@endpush
