@extends('layouts.marketing')
@section('content')

<!-- Business card Start -->
<div id="Statispages" class="wrap-bg">
    <div class="container">
        <h3>Business card for iviggo partners.
        </h3>
        <div id="cardFormPrint">

            <form class="form-inline" id="upload_form" method="post" action="scripts/uploadBusinessCard.php"
                  enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="form-group">

                    <div class="form-group mb-2">

                        <label for="exampleInputEmail1">Add a picture</label> &nbsp;

                        <input required="" type="file" accept="image/jpeg, image/png" class="form-control-file" name="newPic"
                               id="exampleFormControlFile1">

                        <input type="hidden" name="userID" value="{{$user->id}}">

                    </div>

                    {{--<button type="submit" class="color-two btn-custom ">Upload</button>--}}

                </div>

            </form>

            <div class="form-group">

                <label for="exampleInputEmail1">Add a phone number</label>

                <input type="tel" class="form-control" id="cardPhoneInput" value="{{$user->coachInfo->mobile}}" placeholder="Enter phone number">

                <small id="emailHelp" class="form-text text-muted">The number will be added to the business card below.</small>

            </div>

            <button type="button" onclick="window.print();" class="color-two btn-custom "><i
                    class="fa fa-print"></i> Print
            </button>
            <small id="emailHelp" class="form-text text-muted">Save a copy of your business card on your computer by clicking print button.</small>

            <hr>

        </div>
        <div class="row">

            <div id="printArea" class="container">

                <div id="bcFront" class="bcShared">
                    <div class="bordr">

                        <img src="{{ asset('businessCard/iv_logo_base_sm.png') }}">

                        <h3 class="">{{ucwords($user->first_name.' '.$user->last_name)}}</h3>

                        <h4>Business Partner</h4>
                        <div class="img-wrap">

                        </div>

                        <div class="infoBox">

                            <p><i class="fa fa-envelope text-primary"></i> {{$user->email}}</p>

                            <p id="phoneTextField"></p>

                            <p><i class="fa fa-share-alt text-primary"></i> Invitation Code: <b>{{$user->coachInfo->invite_code}}</b></p>

                        </div>
                    </div>
                </div>

                <br>

                <div id="bcBack" class="bcShared">


                    <h1 class="iv">
                        <div class="imgBox"><img
                                src="{{ asset('businessCard/iv_logo_base_sm.png') }}"></div>
                        iviggo.com

                    </h1>
                    <h3>Video coaching - Personal development</h3>


                    <h1 class="ivm">
                        <div class="imgBox"><img
                                src="{{ asset('businessCard/ivm_logo_base_sm.png') }}">
                        </div>
                        partners.iviggo.com


                    </h1>
                    <h3>When effort is rewarded worldwide</h3>

                </div>

            </div>
        </div>
    </div>
</div>
<!-- Business card End-->
@endsection

@push('styles')

    <style>
        @media print {

            body * {

                visibility: hidden !important;

            }

            #cardFormPrint, #footer  {

                display: none !important;

            }

            #printArea,
            #printArea * {

                visibility: visible !important;

            }

        }
    </style>
@endpush

@push('scripts')
<script>


    $(document).ready(function(){

        $("#cardPhoneInput").keyup(function () {

            var phoneNum = $("#cardPhoneInput").val();

            if (phoneNum === "") {

                $("#phoneTextField").html("");

            } else {

                $("#phoneTextField").html("<i class='fa fa-phone text-primary'></i> " + phoneNum);

            }


        });

        $("#cardPhoneInput").bind("keypress", function (e) {
            var keyCode = e.which ? e.which : e.keyCode;

            if(keyCode > 31 && (keyCode < 48 || keyCode>57)) {
                $(this).closest('.form-group').addClass('has-error');
                return false;

            } else {
                $(this).closest('.form-group').removeClass('has-error');
            }



        });


        document.addEventListener('readystatechange', function(event) {

            // When window loaded ( external resources are loaded too- `css`,`src`, etc...)
            if (event.target.readyState === "complete") {
                $("#cardPhoneInput").keyup();
            }
        });




        $(document).ready(function (e) {
            $("#uploadForm").on('submit',(function(e) {
                e.preventDefault();
                $.ajax({
                    url: "upload.php",
                    type: "POST",
                    data:  new FormData(this),
                    beforeSend: function(){$("#body-overlay").show();},
                    contentType: false,
                    processData:false,
                    success: function(data)
                    {
                        $("#targetLayer").html(data);
                        $("#targetLayer").css('opacity','1');
                        setInterval(function() {$("#body-overlay").hide(); },500);
                    },
                    error: function()
                    {
                    }
                });
            }));
        });


        $("#exampleFormControlFile1").change(function(e){
            e.preventDefault();
            showPreview(this);
        });


    });

    function showPreview(objFileInput) {
        if (objFileInput.files[0]) {
            var fileReader = new FileReader();
            fileReader.onload = function (e) {
                $('.img-wrap').html('<img src='+e.target.result+' class=cardPic />');
            }
            fileReader.readAsDataURL(objFileInput.files[0]);
        }
    }

</script>
@endpush
