@extends('layouts.auth')

@section('content')
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <div class="row ">
        <div class="col-md-4 py-5 text-white text-center bg-image-signup ">
            <div class=" ">
                <div class="card-body">
                    <h2 class="py-3">Log ind på Iviggo</h2>

                </div>
            </div>
        </div>
        <div class="col-md-4 offset-md-1 p-5 register-form ">


            <h4 class="pb-4">General Information</h4>
                <form  method="POST" action="{{ route('login') }}" id="login-form" autocomplete="off">
                    {{ csrf_field() }}
                    <input type="hidden" name="timezone" id="timezone" value="">
                    @include('common.flash_messages')
                    <div class="form-row">
                        <div class="form-group col-md-12">
                            <label for="first_name" class="required">E-mail</label>
                            <input id="email" name="email" value="{{ old('email') }}" required class="form-control" type="text">
                        </div>

                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-12">
                            <label for="first_name" class="required">Adgangskode</label>
                            <input id="password" type="password" class="form-control" name="password" auto required>
                        </div>

                    </div>
                    @if(config('services.recaptcha.key'))
                        <div class="g-recaptcha"
                             data-sitekey="{{config('services.recaptcha.key')}}">
                        </div>
                    @endif

                    <div class="form-row pt-3 pl-1">
                        <button type="submit" class="color-two btn-custom ">Indsend</button>
                        <a class="btn btn-link" href="{{ route('password.request') }}">
                            Glemt Din Adgangskode?
                        </a>
                    </div>
            </form>

        </div>

    </div>
@endsection
@push('scripts')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.20.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment-timezone/0.5.14/moment-timezone-with-data-2012-2022.min.js"></script>
    <script>
        $( document ).ready(function() {
                console.log(moment.tz.guess());
                $('#timezone').val(moment.tz.guess());


        });
    </script>

@endpush
