@extends('layouts.app')
@section('content')

    <?php
    if(request('trans_id')){
        $disabled = 'readonly';
        $contract = '';
        $contract2 = '';
        $shouldDisable = 'readonly';
    }else{
        $disabled = '';
        $contract = 'readonly';
        $contract2 = 'style=pointer-events:none';
        $shouldDisable = '';
    }
    $updateFormData = false;
    if(request('updateFormData')){
        $updateFormData = true;
    }
    ?>
    <div id="CoachEditCompany" class="wrap-bg">
        <!-- .container -->
        <div class="container">
            <div class="row">
                <div class="col-md-12 ">

                    <form method="post" enctype="multipart/form-data" id="company-edit-form" action="{{ route('company.submit') }}">
                        <div align="right"><a class="color-two btn-custom" href="{{url()->previous()}}" class="btn btn-default">Afbestille</a></div>
                        {{ csrf_field() }}
                        <input type="hidden" name="company_id" value="{{$company->company_id}}">
                        <input type="hidden" name="company[company_id]" value="{{$company->company_id}}">
                        <?php if($updateFormData){?>
                            <input type="hidden" name="updateFormData" value="1">
                        <?php } ?>
                        @include('common.flash_messages')
                        <h4 class="pb-4">Virksomhedsoplysninger</h4>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="company_name" class="required">firmanavn</label>
                                    <input id="company_name" name="company[company_name]" class="form-control" type="text" value="{{$company->company_name}}" autocomplete="off" {{$disabled}}>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="email" class="required">Firma E-mail</label>
                                    <input type="text" name="company[company_email]" class="form-control" id="email"  value="{{$company->company_email}}" autocomplete="off" {{$disabled}} readonly="readonly">
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="company_website" class="required">Firmaets hjemmeside </label>
                                    <input id="company_website" name="company[company_website]" class="form-control" type="text" value="{{$company->company_website}}"  autocomplete="off" {{$disabled}}>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="no_of_employees" class="required">Potentielt antal ansatte </label>
                                    <input id="no_of_employees" name="company[no_of_employees]" class="form-control" type="text" value="{{$company->no_of_employees}}" autocomplete="off" {{$disabled}}>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="address" class="required">Adresse</label>
                                    <input id="address" name="company[address]" class="form-control" type="text"  value="{{$company->address_line_1}}" autocomplete="off" {{$disabled}}>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="address">Adresselinje 2</label>
                                    <input id="address" name="company[address_line_2]" class="form-control" type="text"  value="{{$company->address_line_2}}" autocomplete="off" {{$disabled}} >
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label>Telefonnummer</label>
                                    <div class="mobilem signup"> <input id="phone" name="company[mobile]" value="{{$company->phone_number}}" class="form-control" type="text"  autocomplete="off" {{$disabled}}></div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="first_name" class="required">Vælg land</label>
                                    {{ Form::select('company[country]', [null=>'Vælg land'] + $countries, old('company[country]',$company->country) , ['class' => 'form-control','id'=>'country','autocomplete'=>'off','readonly'=> $shouldDisable, 'style'=> "pointer-events: none;"]) }}
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="required">CVR</label>
                                    <input id="cvr" name="company[cvr]" value="{{$company->cvr}}" class="form-control" type="text"  autocomplete="off" {{$disabled}}>

                                </div>
                                <div class="form-group col-md-6">
                                    <label>Postnummer</label>
                                    <input id="zip_code" name="company[zip_code]" value="{{$company->postal_code}}" class="form-control" type="text"  autocomplete="off" {{$disabled}}>

                                </div>
                            </div>

                            <h4 class="pb-4">Kontaktpersonoplysninger</h4>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="first_name" class="required">Fornavn</label>
                                    <input id="first_name" name="company[first_name]" class="form-control" type="text"  value="{{$company->owner_first_name}}" autocomplete="off" {{$disabled}}>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="first_name" class="required">Efternavn</label>
                                    <input type="text" class="form-control" id="last_name" name="company[last_name]"  value="{{$company->owner_last_name}}" autocomplete="off" {{$disabled}}>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label>Telefonnummer</label>
                                    <div class="mobilem company"> <input id="phone2" name="company[mobile_number]" value="{{$company->owner_phone_number}}" class="form-control" type="text"  autocomplete="off" {{$disabled}}></div>

                                </div>

                                <div class="form-group col-md-6">
                                    <label for="email">E-mail</label>
                                    <input id="email" name="company[email]" class="form-control" type="text" value="{{$company->owner_email}}" autocomplete="off" {{$disabled}} readonly="readonly">
                                </div>
                            </div>

                            <h4 class="pb-4">Aftale</h4>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="start_date" class="required">Start Dato</label>
                                    <input id="start_date" name="company[start_date]" class="form-control" type="text"  value="{{$company->contract_start_date}}" {{$contract}} {{$contract2}} autocomplete="off"  readonly="" style="background-color: #ffffff" >
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="end_date" class="required">Slutdato</label>
                                    <input id="end_date" name="company[end_date]" class="form-control" type="text"  value="{{$company->contract_end_date}}" autocomplete="off" {{$contract}} {{$contract2}} readonly="">
                                </div>

                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="no_of_members" class="required">Medlemmer </label>
                                    <input id="no_of_members" name="company[no_of_members]" class="form-control" type="text" value="{{$company->agreed_members}}" autocomplete="off" {{$contract}} onchange="showAgreedPrice(), showRenewOptions()">
                                    <p id="nmembers" class="error-msg" style="display: none">Fjern de unødvendige brugere først for denne virksomhed</p>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="first_name" class="required">Månedlig/ medarbejder (min. 5 ELLER maks. 20)</label>
                                    <input id="monthly" name="company[monthly]" class="form-control" type="text" autocomplete="off" {{$contract}} value="{{$company->monthly_per_employee}}"  readonly onchange="showAgreedPrice()">
                                </div>
                            </div>
                        <input type="hidden" name="company[old_members]" value="{{$company->agreed_members}}">
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="annually">Årligt (kr.)</label>
                                    <input id="annually" name="company[annually]" class="form-control" type="text"  value="{{$company->annually_per_employee}}"autocomplete="off"  readonly>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="agreed_price">Aftalt pris (kr.)</label>
                                    <input id="agreed_price" name="company[agreed_price]" class="form-control" type="text" value="{{$company->agreed_price}}" autocomplete="off" readonly>
                                </div>
                            </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="comments_section">Kommentarer</label>
                                <textarea rows="4" cols="116" name="company[message]" {{$contract}}></textarea>
                            </div>
                        </div>
                        <div>
                            <h4 class="pb-0">Kommentarer Historie</h4>
                            @foreach ($message as $object)<br>{{$object->message}}<br> <i><b>Dateret: {{$object->date}}</b></i><br>@endforeach
                        </div>
                        <?php if(isset($previousMembersCount)){?>
                        <input type="hidden" id="previous_m_count" name="company[previous_m_count]" value="{{$previousMembersCount}}">
                        <?php } ?>
                        <div class="form-row pt-3">
                            <button type="submit" class="color-two btn-custom ">Opdatering</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('styles')
    {!! Html::style('css/intlTelInput.css') !!}
@endpush
@push('scripts')
    {!! Html::script('js/intlTelInput.js') !!}
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script>
        $( function() {
            $('#nmembers').hide();
            $('.btn-custom').show();
            var today = new Date();
            var upgradeContract = '<?php echo $_GET['renew']?>';
            var endDate = $('#end_date').val();

                $("#start_date").datepicker({
                    changeMonth: true,
                    changeYear: true,
                    minDate: today,
                    maxDate: '+1y',
                    beforeShow: function( el ){
                        // set the current value before showing the widget
                        $(this).data('previous', $(el).val() );
                    },
                    onSelect: function (today) {
                        var myDate = new Date(today);
                        myDate.setFullYear(myDate.getFullYear() + 1);
                        myDate.setDate(myDate.getDate() - 1);
                        var myval = ((myDate.getMonth() + 1) + "/" + (myDate.getUTCDate() + "/" + myDate.getUTCFullYear()));
                        if(upgradeContract == 0){
                            $("#end_date").val(endDate);
                        }else {
                            $('#end_date').val(myval);
                        }
                        if( $(this).data('previous') != today ){
                            // do whatever has to be done, e.g. log it to console
                            showAgreedPrice();
                        };
                    }

                })


            var myDate = new Date(today);
            var todayDate = ((myDate.getMonth()+1)+ "/" + (myDate.getUTCDate() + "/"+ myDate.getUTCFullYear()));
            myDate.setFullYear(myDate.getFullYear() + 1);
            myDate.setDate(myDate.getDate() - 1);
            var myval = ((myDate.getMonth() + 1)+ "/" + (myDate.getUTCDate() + "/"+ myDate.getUTCFullYear()));

            var endDate = $('#end_date').val();
            if(upgradeContract == 1) {

                $("#start_date").datepicker({
                    changeMonth: false,
                    changeYear: false,
                })

                $( "#start_date").val(todayDate);
                $("#end_date").val(myval);
                //$("#start_date").datepicker("show");

            }else{

                $("#end_date").val(endDate);
            }
        });

        function showAgreedPrice(){
            var noOfMemberships = $('#no_of_members').val();
            var transid = '<?php echo request('trans_id')?>';
            if($("#monthly").val() != '') {
                var startDate = new Date(document.getElementById('start_date').value);
                var endDate = new Date(document.getElementById('end_date').value);
                var months = (Math.max((endDate.getFullYear() - startDate.getFullYear()) * 12 + endDate.getMonth() - startDate.getMonth(), 0));
                var priceForOneMember = $("#monthly").val();
                var monthlyPrice =noOfMemberships * priceForOneMember;
                if(transid!= '') {
                    $('#agreed_price').val(months * monthlyPrice);
                    $('#annually').val(months * monthlyPrice);
                }
            }
        }


        function showRenewOptions(){
            var renewFlag = '<?php echo request('renew')?>';
            if(renewFlag == 1) {
                var previousMembersCount = $("#previous_m_count").val();
                var noOfMemberships = $('#no_of_members').val();

                if (parseInt(noOfMemberships) < parseInt(previousMembersCount)) {
                    $('#nmembers').show();
                    $('.btn-custom').hide();
                } else {
                    $('#nmembers').hide();
                    $('.btn-custom').show();
                }
            }
        }
        var input = document.querySelector("#phone");
        var input2 = document.querySelector("#phone2");
        iti = intlTelInput(input, {
            formatOnDisplay: false,
            separateDialCode: true,
            autoPlaceholder: 'off',
            hiddenInput:"phone",
            autoHideDialCode:true,
            preferredCountries: ["dk"],
            utilsScript: "/js/build/js/utils.js",
        });

        iti2 = intlTelInput(input2, {
            formatOnDisplay: false,
            separateDialCode: true,
            autoPlaceholder: 'off',
            hiddenInput:"phone",
            autoHideDialCode:true,
            preferredCountries: ["dk"],
            utilsScript: "/js/build/js/utils.js",
        });

        var oldPhone = '{{old('general.phone')}}';
        if(typeof iti !== 'undefined' && oldPhone) {
            iti.setNumber(oldPhone);
        }
        if(typeof iti2 !== 'undefined' && oldPhone) {
            iti.setNumber(oldPhone);
        }
    </script>
@endpush

