<?php

namespace App\Mail;

use App\Createcompany;
use App\UserCompanies;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\UserPackage;
use Illuminate\Support\Facades\Log;


class CompanyEmployeesEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $info;
    public $company;
    public $user;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(UserCompanies $company,Createcompany $companyInfo, $userData)
    {
        $this->info = $company;
        $this->company = $companyInfo;
        $this->user = $userData;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Tilmeldingsoplysninger | Virksomhedens ansatte')->view('emails.employees_email');
    }
}
