<?php

namespace App\Http\Middleware;

use App\User;
use Closure;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Exceptions\UnauthorizedException;
use Spatie\Permission\Traits\HasRoles;


class UserMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    use HasRoles;


    public function handle($request, Closure $next)
    {

        if (Auth::guest()) {
            return redirect()->route('home.front');
        }

        if (! Auth::user()->hasRole('user')) {
            return redirect()->route('home.front');
        }

        $permissions = Auth::user()->getPermissionNames()->toArray();

        if(in_array('is_am',$permissions)) {
            $menu = '<li class="subnav"><a href="#">My Admin Panel</a>
                            <ul class="sub-menu">
                                <li><a href="'.route('am.videos').'" class="nav-link ">Approve videos </a></li>
                                <li><a href="'.route('am.intros').'" class="nav-link ">Approve introductory videos </a></li>
                            </ul>
                        </li>';
            session(['menu' => $menu]);
        }

        return $next($request);
    }
}
