<?php

namespace App\Http\Controllers\Marketing;

use App\CoachProfileInfo;
use App\Commissions;
use App\Favorite;
use App\Payouts;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\User;
use Auth;
use DB;
use Carbon\Carbon;
use App\Tag;
use QuickPay\QuickPay;
use Vimeo;
use App\CoachSubscription;
use App\Package;
use Spatie\Image\Exceptions\InvalidManipulation;
use Spatie\Image\Image;
use Spatie\Image\Manipulations;

class AjaxController extends Controller
{
    protected $user;

    public function __construct(Request $request)
    {
        $this->middleware(['ajax']);
    }

    public function uploadD(Request $request) {
        $profile_photo = '';
        $user = Auth::user();
        $code = 200;
        $response = [];
        if ($request->has('input')) {
            // Get image file
            $image = $request->file('input');
            $image_name = time() . '.' . $image->getClientOriginalExtension();
            if (! File::exists(public_path('/uploads/thumbs/'))) {
                File::makeDirectory(public_path('/uploads/thumbs/'));
            }

            if (! File::exists(public_path('/uploads/images/'))) {
                File::makeDirectory(public_path('/uploads/images/'));
            }

            $destinationPath = public_path('/uploads/images/');

            $resize_image = Image::load($image->getRealPath());
            /*$resize_image->fit(Manipulations::FIT_FILL,270,270)->background('ffffff')->save($destinationPath . '270_' . $image_name);

            $resize_image->fit(Manipulations::FIT_FILL,470,510)->background('ffffff')->save($destinationPath . '470_' . $image_name);
            $resize_image->fit(Manipulations::FIT_FILL,115,115)->background('ffffff')->save($destinationPath . '115_' . $image_name);*/

            $resize_image->width(470)->save($destinationPath . $image_name);


            $profile_photo = $image_name;

            $coachInfo = CoachProfileInfo::where('created_user_id',$user->id)->first();

            $coachInfo->photo = $profile_photo;
            $coachInfo->save();

            return response()->json(['image'=>asset('uploads/images/'.$profile_photo),'message'=>'Updated'], $code);


        } else {
            return response()->json(["message" => "Bad request"], 422);
        }
    }


    public function payout(Request $request){

        $this->validate($request, [
            'id' => 'required|integer',
            'amount' => 'required|numeric'
        ]);
        $user = Auth::user();

        $code = 200;
        $response = [];

        $data['commission'] = Commissions::where('partner_id',$user->id)->sum('commission');
        $data['payouts_sum'] = Payouts::where('created_user_id',$user->id)->whereIn('status',['waiting','approved'])->sum('amount');
        $payoutAccountTotals = $data['commission'] - $data['payouts_sum'];

        $data['min'] =config('iviggo.payout_limit');


        if($request->amount <= $payoutAccountTotals &&  $request->amount >= $data['min']) {
            Log::info('Payout Req - 1st');
            $orderID = "ivpay" . $request->id . time();
            $client = new QuickPay(':' . env('QUICKPAY_PAYOUT'));
            $payoutReq = $client->request->post('/payouts', [
                'order_id' => $orderID,
                'currency' => 'eur',
                'variables' => ['id' => $request->id , 'email' => $user->email, 'amount'=>$request->amount*100]
            ]);

            Log::info($payoutReq->httpStatus());
            if ($payoutReq->httpStatus() === 201) {
                Log::info('Payout Req - 2nd - Response Success From QP');
                $payoutReqObject = $payoutReq->asObject();
                $endpoint = sprintf("/payouts/%s/link", $payoutReqObject->id);

                Log::info('Payout Req - 3d - QP link Generation');
                $encryptedStr = Crypt::encryptString($user->id . '**' . $orderID . '**payout');


                //Issue a put request to create payment link
                $link = $client->request->put($endpoint, [
                    "amount" => $request->amount * 100,
                    "language" => 'en',
                    "continue_url" => route('payout.success', ['token' => $encryptedStr]),
                    "cancel_url" => route('payout.fail', ['token' => $encryptedStr]),
                    "callback_url" => route('payout.info')
                ]);

                if ($link->httpStatus() === 200) {

                    $newPayout = new Payouts();
                    $newPayout->amount = $request->amount;
                    $newPayout->status = 'waiting';
                    $newPayout->created_user_id = $request->id;
                    $newPayout->updated_user_id = $request->id;
                    $newPayout->updated_user_id = $request->id;
                    $newPayout->order_id = $orderID;
                    $newPayout->save();


                    Log::info('Payout Req - 4th - 200 from QP link Generation');
                    $subscriptionLink = $link->asObject()->url;

                    session(['qpay_link' => $subscriptionLink]);

                    $response["url"] = $subscriptionLink;
                    return response()->json($response, $code);
                } else {
                    return response()->json(["message" => "Bad request"], 422);
                }


            } else {
                return response()->json(["message" => "Bad request"], 422);
            }
        } elseif($request->amount < $data['min']) {
            return response()->json(["message" => "Minimum Payout amount should not be less than €".config('iviggo.payout_limit')], 422);
        }elseif($request->amount > $payoutAccountTotals) {
            return response()->json(["message" => "Payout amount should not be greater than your account balance. €".$payoutAccountTotals], 422);
        }



        return response()->json($response, $code);
    }




}
