<?php

namespace App\Http\Controllers\Common;

use App\Video;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Countries;
use App\User;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Spatie\Permission\Traits\HasRoles;
use App\Traits\UploadTrait;
use Illuminate\Database\Eloquent\Builder;
use Carbon\Carbon;
use DB;
use App\QuestionReplies;
use App\Question;
use App\Mail\QuestionResponse;
use App\Jobs\SendEmail;


class QuestionsController extends Controller
{

    protected $user;
    use HasRoles;

    public function __construct()
    {

    }

    public function user(Request $request){

        $data = $request->all();
        $this->user = Auth::user();

        $data['categories'] = DB::table('categories')->where('status', 'active')->orderBy('title','asc')->pluck( 'title','id')->toArray();


        $appoved = function ( $q){
            $q->where('status','approved');
        };


        $reply = function ( $q) use ($appoved){
            $q->whereNotNull('video_id')->with(['Video'=>$appoved,'coach'])->whereHas('Video',$appoved);
        };

        $data['questions'] = Question::with(['Replies'=>$reply])->where('created_user_id',$this->user->id)->with('Category')->orderBy('created_at', 'desc')->paginate(12);

        //return $data['questions'];

        return view('common.user_questions', $data);

    }

    public function coach(Request $request){

        $data = $request->all();
        $user = Auth::user();


        $appoved = function ( $q){
            $q->where('status','approved');
        };


        $reply = function ( $q) use ($user){
            $q->where('coach_id',$user->id);
        };

        //$data['questions'] = Question::with(['Replies'=>$reply])->with('Category')->where('created_at','>', Carbon::now()->subDays(90))->orderBy('created_at', 'desc')->paginate(12);
        $data['questions'] = Question::with(['Replies'=>$reply])->with('Category')->orderBy('created_at', 'desc')->paginate(12);

        //return $data;
        $user = Auth::user();

        $userFilter = function ($q) use($user){
            $q->where('id', $user->id);
        };
        $data['videos'] = Video::with(['user' => $userFilter])->where('status','approved')->whereHas('user', $userFilter)->get();


        return view('common.coach_questions', $data);

    }

    protected function validator(array $data)
    {
        $validator = Validator::make($data, [
            'question' => 'required|array',
            'question.title' => 'required',
            'question.category_id' => 'required|integer',
            'question.description' => 'required',
        ], [
            'title' => 'Title is required.',
            'category_id' => 'Please select category from the list',
            'description' => 'Description is required.'
        ],['question.title' => 'Title',
            'question.category_id' => 'Category',
            'question.description' => 'Description']);

        return $validator;
    }


    public function add(Request $request) {
        $this->user = Auth::user();




        $this->validator($request->all())->validate();
        $pageRefresh = $request->input('page_refresh');



        $this->default_condition = ["created_user_id" => $this->user->id, "updated_user_id" => $this->user->id];

        $question = $request->question;
        $question['created_user_id'] = $this->user->id;
        $question['updated_user_id'] = $this->user->id;

        $rec = Question::create($question);

        if(isset($rec->id)) {
            $coaches = User::role(['superadmin','coach'])->select('id','email','first_name','last_name','status')->where('status','active')->get();

            foreach($coaches as $coach) {

                $details = ['question' => $rec->title, 'description'=>$rec->description,'email' => $coach->email,'first_name'=>$coach->first_name,'last_name'=>$coach->last_name];

                SendEmail::dispatch($details);

                //new App\Jobs\Send($details)
            }

            if($pageRefresh=='no') {
                return response()->json(["message" => "Question is added and sent to coaches.",'status'=>'success']);
            }

        } else {
            if($pageRefresh=='no') {
                return response()->json(["message" => "Bad Request"],422);
            }
        }



        return redirect()->route('questions')->with('status', "Question is added and sent to coaches.");
    }

    public function update(Request $request) {
        $this->user = Auth::user();

        $data['question_id'] = $request->input("question");
        $videos = $request->input("videos");


        if(!is_numeric($data['question_id']) || $data['question_id'] == 0 || strpos($data['question_id'], "."))
        {
            return response()->json(["message" => "Bad request"], 422);
        }

        if(!is_array($videos))
        {
            return response()->json(["message" => "Bad request"], 422);
        }

        $code = 200;
        $response = [];

        foreach($videos as $video) {
            QuestionReplies::firstOrCreate(
                ['question_id' => trim($data['question_id']), 'video_id'=>$video, 'coach_id'=>$this->user->id, 'status'=>'read']
            );
        }

        $appoved = function ( $q){
            $q->where('status','approved');
        };

        $reply = function ( $q) use ($appoved){
            $q->whereNotNull('video_id')->with(['Video'=>$appoved,'coach'])->whereHas('Video',$appoved);
        };


        $question = Question::with(['Replies'=>$reply])->where('id',$data['question_id'])->first();
        $question->user = User::find($question->created_user_id);
        Mail::to($question->user->email)->send(new QuestionResponse($question));
        //$response["questionObj"] = $question;

        $response["message"] = "Question is replied with selected videos.";


        return response()->json($response, $code);
    }


}
