<?php

namespace App\Http\Controllers\Bo;

use App\Presentation;
use App\Staff;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Spatie\Permission\Traits\HasRoles;
use App\SitePages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use App\QuestionReplies;
use App\Question;
use App\Mail\QuestionResponse;

use Auth;



class QuestionsController extends Controller
{
    use HasRoles;

    public function __construct()
    {
        $this->middleware(['auth', 'isSuper']);

    }



    public function index(Request $request)
    {
        $data['items'] = Question::with(['Category','user'=>function ($q) {
            return $q->withTrashed();
        }])->orderby('id', 'DESC')->paginate(24);
      //  return $data;
        return view('bo.questions',$data);
    }

    public function delete($id) {
        if (!is_numeric($id) || $id == 0 || strpos($id, ".")) {
            return redirect(route('bo.questions'))->with('message','record not found');
        }


        $record = Question::find($id);
        if(isset($record->id)) {
            $record->delete();
        } else {
            return redirect(route('bo.questions'))->with('error', 'Question not found!');
        }

        return redirect(route('bo.questions'))->with('success', 'Question deleted!');
    }

}
