<?php

namespace App\Exports;

use App\CompanyQuickpayPayments;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;


class CompanyPayoutsExports implements FromCollection
{
    /**
     * @return \Illuminate\Support\Collection
     */

    private $month;
    private $year;

    public function __construct($month,$year) {
        $this->month = $month;
        $this->year = $year;
    }


    public function collection()
    {
        //

        $payments = CompanyQuickpayPayments::with(['commissions','user'=>function ($q) {
            $q->withTrashed();
        }])->whereMonth('created_at', $this->month)->whereYear('created_at', $this->year)->where('type','Payment')->where('State','Approved')->orderBy('created_at', 'asc')->get();
        //return $payments;
        $collection = new Collection();
        $collection[] = ['Date','User Name','Email','Payment ID','Order ID','Payment Type','Package Amount','Vat','Vat Percentage','Total Amount','Total Payout','TEO Payout','Simon Payout','Peter Payout','Remaining Total'];
        if($payments) {

            $i = 1;
            foreach($payments as $item) {


                $results = [];
                $results['Date'] = Carbon::parse($item->created_at)->format('d-m-Y H:i:s');
                $results['User Name'] = $item->user->first_name.' '.$item->user->last_name;
                $results['Email'] = $item->user->email;
                $results['Payment ID'] = $item->payment_id;
                $results['Order ID'] = $item->order_id;
                $results['Payment Type'] = $item->type;
                if($item->type=='Refund') {
                    $results['Package Amount'] = -1 * number_format($item->amount, 2, '.', '');
                    $results['Vat'] = number_format((($item->balance/100)-$item->amount), 2, '.', '');
                    $results['Vat Percentage'] = ($item->vat+0).'%';
                    $results['Total Amount'] = -1 * number_format(($item->balance/100), 2, '.', '');
                    $results['Commission Total'] = number_format($item->commissions->pluck('commission')->sum(), 2, '.', '');
                    /*$results['Speakers Pool'] = '0.00';*/
                    $results['TEO'] = '0.00';
                    $results['Simon'] = '0.00';
                    $results['Peter'] = '0.00';
                    $remaining_total = $results['Package Amount'];
                    $results['Remaining Total'] = number_format($remaining_total, 2, '.', '');
                } else {
                    $results['Package Amount'] = number_format($item->amount, 2, '.', '');
                    $results['Vat'] = number_format((($item->balance/100)-$item->amount), 2, '.', '');
                    $results['Vat Percentage'] = ($item->vat+0).'%';
                    $results['Total Amount'] = number_format(($item->balance/100), 2, '.', '');
                    $results['Commission Total'] = number_format($item->commissions->pluck('commission')->sum(), 2, '.', '');
                    //$results['Speakers Pool'] = (count($item->pool)>0) ? number_format($item->pool->pluck('amount')->sum(), 2, '.', '') : '0.00';
                    $results['TEO'] = number_format(($item->amount * config('iviggo.teo_payout')['percentage']) / 100, 2, '.', '');
                    $results['Simon'] = number_format(($item->amount * config('iviggo.teo_payout')['percentage']) / 100, 2, '.', '');
                    $results['Peter'] = number_format(($item->amount * config('iviggo.peter_payout')['percentage']) / 100, 2, '.', '');
                    $remaining_total = $results['Package Amount'] - $results['Commission Total'] - $results['TEO'] - $results['Simon'] -  $results['Peter'];
                    $results['Remaining Total'] = number_format($remaining_total, 2, '.', '');
                }


                $collection[] = $results;
            }




            return $collection;
        } else {
            return [];
        }

    }
}
