<?php

namespace App\Console\Commands;

use App\CoachIntro;
use App\Video;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\File;
use Vimeo\Laravel\Facades\Vimeo;
use Image;
use Illuminate\Support\Facades\Log;


class videoCheck extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    use SoftDeletes;
    protected $signature = 'video:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check Video with Vimeo and Update';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //
        $items = Video::where('vimeo_callback','pending')->where('created_at', '<',
            Carbon::now()->subHours(2)->toDateTimeString()
        )->get();


        if(count($items) > 0) {
            foreach($items as $item) {
                $vimResponse = Vimeo::request('/videos/'.$item->video_id, '', 'GET');
                print json_encode($vimResponse);
                print PHP_EOL;
                if(isset($vimResponse['body']['duration'])) {
                    if(!empty($vimResponse['body']['duration'])) {
                        $item->video_duration = $vimResponse['body']['duration'];
                        $item->vimeo_callback = 'done';
                    }

                    if (isset($vimResponse['body']['pictures'])) {
                        foreach ($vimResponse['body']['pictures']['sizes'] as $key => $thumbSizes) {
                            if ($key === 4 && isset($thumbSizes['link']) && !empty($thumbSizes['link'])) {
                                Log::info($thumbSizes['link']);
                                if (! File::exists(public_path('/uploads/thumbs/'))) {
                                    File::makeDirectory(public_path('/uploads/thumbs/'));
                                }


                                $newImageName = time() . '.' .'jpg';
                                Image::make($thumbSizes['link'])->save(public_path('/uploads/images/' . $newImageName ));
                                Image::make($thumbSizes['link'])->save(public_path('/uploads/thumbs/' . '263_' . $newImageName ));


                                //if($item->video_thumbnail=='video_landing.jpg') {
                                    $item->video_thumbnail = $newImageName;

                                //}
                                $item->video_duration = $vimResponse['body']['duration'];

                            }
                        }
                    }

                    $item->save();


                }
            }
        }

        $items = CoachIntro::where('vimeo_callback','pending')->where('created_at', '<',
            Carbon::now()->subHours(2)->toDateTimeString()
        )->get();

        if(count($items) > 0) {
            foreach($items as $item) {
                $vimResponse = Vimeo::request('/videos/'.$item->video_id, '', 'GET');
                if(isset($vimResponse['body']['duration'])) {
                    if (isset($vimResponse['body']['pictures'])) {
                        foreach ($vimResponse['body']['pictures']['sizes'] as $key => $thumbSizes) {
                            if ($key === 4 && isset($thumbSizes['link']) && !empty($thumbSizes['link'])) {
                                $newImageName = time() . '.' .'jpg';
                                Image::make($thumbSizes['link'])->save(public_path('/uploads/images/' . $newImageName ));
                                Image::make($thumbSizes['link'])->save(public_path('/uploads/thumbs/' . '270_' . $newImageName ));
                                Image::make($thumbSizes['link'])->save(public_path('/uploads/thumbs/' . '370_' . $newImageName ));
                                if($item->video_thumbnail=='video_landing.jpg') {
                                    $item->video_thumbnail = $newImageName;

                                }
                                $item->video_duration = $vimResponse['body']['duration'];
                                $item->vimeo_callback = 'done';

                            }
                        }
                    }



                    $item->save();
                }
            }
        }

    }
}
